% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBalance.R
\name{getBalance}
\alias{getBalance}
\title{Download balance of account}
\usage{
getBalance(token = "", live = FALSE, verbose = FALSE)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the information about balance of account.
}
\description{
Makes a request to the server, and returns an data.table object with information about available balance if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getBalance(token,live)
}
\seealso{
\code{\link{getAccounts}} \code{\link{getPortfolio}}
}
\author{
Vyacheslav Arbuzov
}
