% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{inv_emax_eleveld}
\alias{inv_emax_eleveld}
\title{Inverse Emax function}
\usage{
inv_emax_eleveld(pdresp, pars)
}
\arguments{
\item{pdresp}{PD response values}

\item{pars}{A vector of parameter values of length 5 corresponding to parameters
(c50,gamma,gamma2,E0,Emx). 'c50' describes the concentration required for 50% effect, 'gamma'
and 'gamma2' are the Hill parameter for concentrations before and after c50, respectively,
'e0' is the response value at a concentration of 0 and 'emx' is the maximum change in response.}
}
\value{
Returns a numeric vector of effect-site concentrations calculated by inverting
the Emax model used by Eleveld et al. (2018).
}
\description{
Inverse of Emax function used by Eleveld et al. (2018) population PK model.
The Emax function has five parameters: the
}
\examples{
pars_emax_eleveld <- c(c50 = 1.5, gamma = 1.47, gamma2 = 1.89, e0 = 100, emx = 100)
ce_seq <- seq(0,4,0.1)
all.equal(inv_emax_eleveld(emax_eleveld(ce_seq, pars_emax_eleveld), pars_emax_eleveld), ce_seq)
}
