% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{eleveld_poppk}
\alias{eleveld_poppk}
\title{Eleveld population PK model}
\usage{
eleveld_poppk(df, PD = TRUE, rate = FALSE, rand = FALSE)
}
\arguments{
\item{df}{Data frame with variable names "AGE","PMA","WGT","HGT","M1F2","TECH",and "A1V2"}

\item{PD}{Logical. Should PD parameters be returned in addition to PK parameters.
Defaults to TRUE.}

\item{rate}{Logical. Should rate parameters be returned rather than clearance.
Defaults to FALSE}

\item{rand}{Logical. Should a vector of Monte Carlo samples be returned instead
of point estimates at patient covariate values. Defaults to FALSE.}
}
\value{
Returns the original data frame with columns added corresponding to patient PK-PD parameter values.
}
\description{
Function to generate PK-PD parameters for the Eleveld et al. (2018) PK-PD model.
Function takes a data frame of patient covariate values with variable names
"AGE","PMA","WGT","HGT","M1F2","TECH",and "A1V2" and returns PK parameter values. PK-PD values
are generated at the point estimates for each patient (i.e. based on covariates alone) by default;
however, random sets of parameter values can be drawn through Monte Carlo simulation based on
the random effect/population variance terms described in Eleveld et al.
}
\examples{
dat <- data.frame(AGE  = c(20,40,65),
                  TBM  = c(50,70,90),
                  HGT  = c(150,170,200),
                  MALE = c(TRUE,FALSE,TRUE))

schnider_poppk(dat, rand = FALSE, rate = FALSE)
schnider_poppk(dat, rand = TRUE, rate = TRUE)
}
