% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mitcr.R
\name{startmitcr}
\alias{startmitcr}
\title{Start MiTCR directly from the package.}
\usage{
startmitcr(.input = "", .output = "", ..., .file.path = "",
  .mitcr.path = "~/programs/", .mem = "4g")
}
\arguments{
\item{.input,.output}{Input and output files.}

\item{...}{Specify input and output files and arguments
of the MITCR without first '-' to run it.}

\item{.file.path}{Path prepending to \code{.input} and \code{.output}.
If input and output is empty, but .file.path is specified,
than process all files from the folder \code{.file.path}}

\item{.mitcr.path}{Path to MiTCR .jar file.}

\item{.mem}{Volume of memory available to MiTCR.}
}
\description{
Start the MiTCR tools directly from the package with given settings.
}
\details{
Don't use spaces in paths!
You should have insalled JDK 1.7 to make it works.
}
\examples{
\dontrun{
# Equal to
# java -Xmx8g -jar ~/programs/mitcr.jar -pset flex
#      -level 2 ~/data/raw/TwA1_B.fastq.gz ~/data/mitcr/TwA1_B.txt
startmitcr('raw/TwA1_B.fastq.gz', 'mitcr/TwA1_B.txt', .file.path = '~/data/',
  pset = 'flex', level = 1, 'debug', .mitcr.path = '~/programs/', .mem = '8g')
}
}

