% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnrs.R
\name{tnrs}
\alias{tnrs}
\alias{tnrs,character-method}
\alias{tnrs,taxlist-method}
\title{Taxonomic Name Resolution Service}
\usage{
tnrs(query, ...)

\S4method{tnrs}{character}(query, ...)

\S4method{tnrs}{taxlist}(query, min_score = 0.8, source = "iPlant_TNRS", ...)
}
\arguments{
\item{query}{Either a character vector or a taxlist object with names to
search.}

\item{...}{Further arguments passed to \code{\link[taxize:tnrs-defunct]{taxize::tnrs()}}.}

\item{min_score}{Minimum value of score for considering accepted names as
suggested by the output.}

\item{source}{Source database.}
}
\value{
A data frame or an object of class \linkS4class{taxlist}.
}
\description{
Methods of \code{\link[taxize:tnrs-defunct]{taxize::tnrs()}} for \linkS4class{taxlist} objects.
}
\details{
This function checks for matching of taxon names in \linkS4class{taxlist}
objects with the Taxonomic Name Resolution Service (TNRS).
Misspelled names as well as author names will be replaced in the the new
object and new accepted names will be inserted.

A method for character vectors is defined for the original function.
}
\seealso{
\code{\link[taxize:tnrs-defunct]{taxize::tnrs()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
