% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_views.R
\name{taxon_views}
\alias{taxon_views}
\alias{taxon_views,taxlist-method}
\alias{taxon_views<-}
\alias{taxon_views<-,taxlist,data.frame-method}
\alias{add_view}
\alias{add_view,taxlist-method}
\title{Management of concept views in taxonomic lists.}
\usage{
taxon_views(taxlist, ...)

\S4method{taxon_views}{taxlist}(taxlist, ...)

taxon_views(taxlist) <- value

\S4method{taxon_views}{taxlist,data.frame}(taxlist) <- value

add_view(taxlist, ...)

\S4method{add_view}{taxlist}(taxlist, ...)
}
\arguments{
\item{taxlist}{A \linkS4class{taxlist} object.}

\item{...}{Further arguments to be passed among methods.}

\item{value}{An object of class \link{data.frame} containing the references
used to define the circumscription of taxon concepts included in
\code{taxlist}.}
}
\value{
An object of class \linkS4class{taxlist} with added views.
}
\description{
Retrieve or replace slot \code{taxonViews} in an object of class \linkS4class{taxlist}
}
\details{
Taxon views indicate in \linkS4class{taxlist} objects the references
determining the circumscription of the respective taxon concepts.
When adding a new concept (see \code{\link[=add_concept]{add_concept()}}), the respective
reference may not yet occur in the input \linkS4class{taxlist} object.

The term taxon view was introduced by \strong{Zhong et al. (1996)} and
corresponds to the reference used for the definition of a concept.

This function retrieves the slot \code{taxonViews} from objects of the class
\linkS4class{taxlist}.

The replacement method \verb{taxon_views<-} replaces the whole content of slot
\code{taxonViews} and it is only recommended to use when constructing a new
\linkS4class{taxlist} object from an empty prototype.
}
\examples{
## See existing views
taxon_views(Easplist)

## Add a new view
Easplist <- add_view(taxlist=Easplist, secundum="Beentje et al. (1952)",
  Title="Flora of Tropical East Africa",
  URL="http://www.kew.org/science/directory/projects/FloraTropEAfrica.html")

taxon_views(Easplist)

}
\references{
\bold{Zhong Y, Jung S, Pramanik S, Beaman JH (1996).} Data model and
comparison and query methods for interacting classifications in a taxonomic
database.
\emph{Taxon} 45: 223--241.
\url{https://doi.org/10.1093/bioinformatics/15.2.149}
}
\seealso{
\linkS4class{taxlist}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
