% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_load.R
\name{db_load}
\alias{db_load}
\alias{db_load_itis}
\alias{db_load_tpl}
\alias{db_load_col}
\alias{db_load_gbif}
\title{Load taxonomic databases}
\usage{
db_load_itis(path, user, pwd = NULL, verbose = TRUE)

db_load_tpl(path, user, pwd = NULL, verbose = TRUE)

db_load_col(path, user = "root", pwd = NULL, verbose = TRUE)

db_load_gbif(verbose = TRUE)
}
\arguments{
\item{path}{(character) path to the \code{.sql} database file}

\item{user}{(character) User name}

\item{pwd}{(character) Password, if any}

\item{verbose}{(logical) Print messages. Default: \code{TRUE}}
}
\value{
Nothing, just message on success
}
\description{
Load taxonomic databases
}
\details{
These functions load SQL DBs into the respective driver,
and they return the file path, but they don't load the database

We check if the database used for each source is installed on
your machine first. and if it is running or not, with errors
for the user if neither are true.
}
\section{Supported}{

\itemize{
\item ITIS - PostgreSQL
\item the PlantList - PostgreSQL
\item Catalogue of Life - MySQL
\item GBIF - SQLite
}
}

\section{Beware}{

COL database loading takes a long time, e.g., 30 minutes. you may
want to run it in a separate R session, or just look at the db_load_col fxn
and run the commands in your shell.
}

\examples{
\dontrun{
# ITIS
# x <- db_download_itis()
# db_load_itis(x, "<your user name>", "<your password>")

# Plantlist
# x <- db_download_tpl()
# db_load_tpl(x, "<your user name>", "<your password>")

# COL
x <- db_download_col()
db_load_col(x, "<your user name>", "<your password>")

# GBIF
## only checks if sqlite installed
db_load_gbif()
}
}
