% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnr_datasources.R
\name{gnr_datasources}
\alias{gnr_datasources}
\title{Global Names Resolver Data Sources}
\usage{
gnr_datasources(..., todf)
}
\arguments{
\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}

\item{todf}{defunct, always get a data.frame back now}
}
\value{
data.frame/tibble
}
\description{
Retrieve data sources used in the Global Names Resolver
}
\examples{
\dontrun{
# all data sources
gnr_datasources()

# give me the id for EOL
out <- gnr_datasources()
out[out$title == "EOL", "id"]

# Fuzzy search for sources with the word zoo
out <- gnr_datasources()
out[agrep("zoo", out$title, ignore.case = TRUE), ]
}
}
\references{
https://resolver.globalnames.org/data_sources
}
\seealso{
\code{\link[taxize]{gnr_resolve}}, \code{\link[taxize]{gni_search}}
}
\keyword{names}
\keyword{resolve}
\keyword{taxonomy}
