% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fungorum.R
\name{fungorum}
\alias{fg_all_updated_names}
\alias{fg_author_search}
\alias{fg_deprecated_names}
\alias{fg_epithet_search}
\alias{fg_name_by_key}
\alias{fg_name_full_by_lsid}
\alias{fg_name_search}
\alias{fungorum}
\title{Index Fungorum}
\usage{
fg_name_search(q, anywhere = TRUE, limit = 10, ...)

fg_author_search(q, anywhere = TRUE, limit = 10, ...)

fg_epithet_search(q, anywhere = TRUE, limit = 10, ...)

fg_name_by_key(key, ...)

fg_name_full_by_lsid(lsid, ...)

fg_all_updated_names(date, ...)

fg_deprecated_names(date, ...)
}
\arguments{
\item{q}{(character) Query term}

\item{anywhere}{(logical) Default: \code{TRUE}}

\item{limit}{(integer) Number of results to return}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{key}{(character) A IndexFungorum taxon key}

\item{lsid}{(character) an LSID, e.,g. "urn:lsid:indexfungorum.org:names:81085"}

\item{date}{(character) Date, of the form YYYMMDD}
}
\value{
A \code{data.frame}, or NULL if no results
}
\description{
Search for taxonomic names in Index Fungorum
}
\examples{
\dontrun{
# NameSearch
fg_name_search(q = "Gymnopus", limit = 2)
fg_name_search(q = "Gymnopus")

# EpithetSearch
fg_epithet_search(q = "phalloides")

# NameByKey
fg_name_by_key(17703)

# NameFullByKey
fg_name_full_by_lsid("urn:lsid:indexfungorum.org:names:81085")

# AllUpdatedNames
fg_all_updated_names(date=20151019)

# DeprecatedNames
fg_deprecated_names(date=20151001)

# AuthorSearch
fg_author_search(q = "Fayod", limit = 2)
}
}
\references{
\url{http://www.indexfungorum.org/}, API docs:
\url{http://www.indexfungorum.org/ixfwebservice/fungus.asmx}
}

