% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/children.R
\name{children}
\alias{children}
\alias{children.colid}
\alias{children.default}
\alias{children.ids}
\alias{children.tsn}
\alias{children.uid}
\title{Retrieve immediate children taxa for a given taxon name or ID.}
\usage{
children(...)

\method{children}{default}(x, db = NULL, rows = NA, ...)

\method{children}{tsn}(x, db = NULL, ...)

\method{children}{colid}(x, db = NULL, ...)

\method{children}{ids}(x, db = NULL, ...)

\method{children}{uid}(x, db = NULL, ...)
}
\arguments{
\item{...}{Further args passed on to \code{\link{col_children}},
\code{\link{gethierarchydownfromtsn}}, or \code{\link{ncbi_children}}.
See those functions for what parameters can be passed on.}

\item{x}{Vector of taxa names (character) or IDs (character or numeric) to query.}

\item{db}{character; database to query. One or more of \code{itis}, \code{col}, or \code{ncbi}.
Note that each taxonomic data source has their own identifiers, so that if you
provide the wrong \code{db} value for the identifier you could get a result,
but it will likely be wrong (not what you were expecting).}

\item{rows}{(numeric) Any number from 1 to inifity. If the default NA, all rows are
considered. Note that this parameter is ignored if you pass in a taxonomic id of any of the
acceptable classes: tsn, colid. NCBI has a method for this function but rows doesn't work.}
}
\value{
A named list of data.frames with the children names of every supplied taxa.
You get an NA if there was no match in the database.
}
\description{
This function is different from \code{\link{downstream}} in that it only collects immediate
taxonomic children, while \code{\link{downstream}} collects taxonomic names down to a specified
taxonomic rank, e.g., getting all species in a family.
}
\examples{
\dontrun{
# Plug in taxonomic IDs
children(161994, db = "itis")
children(8028, db = "ncbi")
children("578cbfd2674a9b589f19af71a33b89b6", db = "col")
## works with numeric if as character as well
children("161994", db = "itis")

# Plug in taxon names
children("Salmo", db = 'col')
children("Salmo", db = 'itis')
children("Salmo", db = 'ncbi')

# Plug in IDs
(id <- get_colid("Apis"))
children(id)

## Equivalently, plug in the call to get the id via e.g., get_colid into children
identical(children(id), children(get_colid("Apis")))

(id <- get_colid("Apis"))
children(id)
children(get_colid("Apis"))

# Many taxa
(sp <- names_list("genus", 3))
children(sp, db = 'col')
children(sp, db = 'itis')

# Two data sources
(ids <- get_ids("Apis", db = c('col','itis')))
children(ids)
## same result
children(get_ids("Apis", db = c('col','itis')))

# Use the rows parameter
children("Poa", db = 'col')
children("Poa", db = 'col', rows=1)

# use curl options
library("httr")
res <- children("Poa", db = 'col', rows=1, config=verbose())
res <- children("Salmo", db = 'itis', config=verbose())
res <- children("Salmo", db = 'ncbi', config=verbose())
}
}

