% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tl.R
\name{tl}
\alias{tl}
\title{taxalight query: rapidly look up scientific names from a local database}
\usage{
tl(
  x,
  provider = getOption("tl_default_provider", "itis"),
  version = tl_latest_version(),
  dir = tl_dir()
)
}
\arguments{
\item{x}{character vector of either scientific names or
taxonomic identifiers (with prefix).  Can mix and match too.}

\item{provider}{Abbreviation for a known naming provider.
Provider data should first be imported with \verb{[tl_create]}.
Note: setting provider to \code{"itis_test"} is for testing purposes only,
use \code{"itis"} for the full ITIS data.  See details}

\item{version}{version of the authority to use (e.g. four-digit year)}

\item{dir}{storage location for the LMDB databases}
}
\value{
a data.frame in Darwin Core format with rows matching the
acceptedNameUsageID or scientificName requested.
}
\description{
taxalight query: rapidly look up scientific names from a local database
}
\details{
Naming providers currently recognized by \code{taxalight} are:
\itemize{
\item \code{itis}: Integrated Taxonomic Information System, \url{https://www.itis.gov/}
\item \code{ncbi}:  National Center for Biotechnology Information,
\url{https://www.ncbi.nlm.nih.gov/taxonomy}
\item \code{col}: Catalogue of Life, \url{http://www.catalogueoflife.org/}
\item \code{gbif}: Global Biodiversity Information Facility, \url{https://www.gbif.org/}
\item \code{ott}: OpenTree Taxonomy: \url{https://github.com/OpenTreeOfLife/reference-taxonomy}
\item \code{itis_test}: a small subset of ITIS, cached locally for testing purposes only.
}

The default provider is \code{itis}, which can be reconfigured by setting
\code{tl_default_provider} in \verb{[options]}.
}
\examples{

\dontshow{Sys.setenv(TAXALIGHT_HOME=tempfile())}

\donttest{ # slow initial import
sp <- c("Dendrocygna autumnalis", "Dendrocygna bicolor")
id <- c("ITIS:180092", "ITIS:179913")

## example uses "itis_test" provider for illustration only:
tl(sp, "itis_test")
tl(id, "itis_test")

}
\dontshow{Sys.unsetenv("TAXALIGHT_HOME")}

}
\seealso{
\link{tl_create}
}
