% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R,
%   R/getter_setter_s3_generics.R, R/taxon.R, R/taxonomy.R
\name{tax_rank.taxa_classification}
\alias{tax_rank.taxa_classification}
\alias{tax_rank<-.taxa_classification}
\alias{tax_rank}
\alias{tax_rank<-}
\alias{tax_rank.taxa_taxon}
\alias{tax_rank<-.taxa_taxon}
\alias{tax_rank.taxa_taxonomy}
\alias{tax_rank<-.taxa_taxonomy}
\title{Set and get taxon ranks}
\usage{
\method{tax_rank}{taxa_classification}(x)

\method{tax_rank}{taxa_classification}(x) <- value

tax_rank(x)

tax_rank(x) <- value

\method{tax_rank}{taxa_taxon}(x)

\method{tax_rank}{taxa_taxon}(x) <- value

\method{tax_rank}{taxa_taxonomy}(x)

\method{tax_rank}{taxa_taxonomy}(x) <- value
}
\arguments{
\item{x}{An object with taxon ranks.}

\item{value}{The taxon ranks to set. Inputs will be coerced into a \link{taxon_rank} vector.}
}
\description{
Set and get the taxon ranks in objects that have them, such as \link{taxon} objects.
}
\examples{
x <- taxon(name = c('Homo sapiens', 'Bacillus', 'Ascomycota', 'Ericaceae'),
           rank = c('species', 'genus', 'phylum', 'family'),
           id = taxon_id(c('9606', '1386', '4890', '4345'), db = 'ncbi'),
           auth = c('Linnaeus, 1758', 'Cohn 1872', NA, 'Juss., 1789'))

tax_rank(x)
tax_rank(x) <- 'species'
tax_rank(x)[1] <- taxon_rank('family')

}
