% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_network.R
\name{tar_resources_network}
\alias{tar_resources_network}
\title{Target resources for network connections}
\usage{
tar_resources_network(
  seconds_interval = 0.25,
  seconds_timeout = 60,
  max_tries = Inf,
  verbose = TRUE
)
}
\arguments{
\item{seconds_interval}{Nonnegative numeric of length 1,
number of seconds to wait between individual retries
while attempting to download, upload, or check
a remote network resource on a network file system (in the case of
\code{storage = "worker"} or \code{format = "file"})
or via HTTP/HTTPS in cases like \code{format = "url"},
\code{repository = "aws"}, and \code{repository = "gcp"}.}

\item{seconds_timeout}{Nonnegative numeric of length 1,
number of seconds to wait before timing out
while attempting to download, upload, or check
a remote network resource on a network file system (in the case of
\code{storage = "worker"} or \code{format = "file"})
or via HTTP/HTTPS in cases like \code{format = "url"},
\code{repository = "aws"}, and \code{repository = "gcp"}.
For files saved to a network file system in the case of
\code{storage = "worker"}, it is recommended to set \code{seconds_timeout}
to at least \code{60}.}

\item{max_tries}{Nonnegative numeric of length 1,
maximum number of tries to download, upload, or check things
while attempting to access a remote network resource on a
network file system (in the case of \code{storage = "worker"})
or via HTTP/HTTPS in cases like \code{format = "url"},
\code{repository = "aws"}, and \code{repository = "gcp"}.}

\item{verbose}{Logical of length 1, whether to print an informative message
when an HTTP/HTTPS attempt fails.}
}
\value{
Object of class \code{"tar_resources_network"}, to be supplied
to the network argument of \code{tar_resources()}.
}
\description{
Create the \code{network} argument of \code{tar_resources()}
to specify optional settings for storage configurations that
rely on network file systems or network connections,
such as \code{storage = "worker"}, \code{format = "url"},
\code{repository = "aws"}, and \code{repository = "gcp"}.
}
\details{
The settings in these resources
configure how to handle unreliable network connections
in the case of uploading, downloading, and checking data
in situations that rely on network file systems or
HTTP/HTTPS requests. Specifically,
they configure retries and timeouts. These settings do not
apply to actions you take in the custom R command of the target.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.

In \code{targets} version 0.12.2 and above, resources are inherited one-by-one
in nested fashion from \code{tar_option_get("resources")}.
For example, suppose you set
\code{tar_option_set(resources = tar_resources(aws = my_aws))},
where \code{my_aws} equals \code{tar_resources_aws(bucket = "x", prefix = "y")}.
Then, \verb{tar_target(data, get_data()} will have bucket \code{"x"} and
prefix \code{"y"}. In addition, if \code{new_resources} equals
\verb{tar_resources(aws = tar_resources_aws(bucket = "z")))}, then
\code{tar_target(data, get_data(), resources = new_resources)}
will use the new bucket \code{"z"}, but it will still use the prefix \code{"y"}
supplied through \code{tar_option_set()}. (In \code{targets} 0.12.1 and below,
options like \code{prefix} do not carry over from \code{tar_option_set()} if you
supply non-default resources to \code{tar_target()}.)
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name = your_name,
  command = your_command(),
  format = "url",
  resources = tar_resources(
    network = tar_resources_network(max_tries = 3)
  )
)
}
}
\seealso{
Other resources: 
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_crew}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
