% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_clustermq.R
\name{tar_resources_clustermq}
\alias{tar_resources_clustermq}
\title{Target resources: \code{clustermq} high-performance computing}
\usage{
tar_resources_clustermq(
  template = targets::tar_option_get("resources")$clustermq$template
)
}
\arguments{
\item{template}{Named list, \code{template} argument to
\code{clustermq::workers()}. Defaults to an empty list.}
}
\value{
Object of class \code{"tar_resources_clustermq"}, to be supplied
to the \code{clustermq} argument of \code{tar_resources()}.
}
\description{
Create the \code{clustermq} argument of \code{tar_resources()}
to specify optional high-performance computing settings
for \code{tar_make_clustermq()}.
For details, see the documentation of the \code{clustermq} R package
and the corresponding argument names in this help file.
}
\details{
\code{clustermq} workers are \emph{persistent},
so there is not a one-to-one correspondence between workers and targets.
The \code{clustermq} resources apply to the workers, not the targets.
So the correct way to assign \code{clustermq} resources is through
\code{\link[=tar_option_set]{tar_option_set()}}, not \code{\link[=tar_target]{tar_target()}}. \code{clustermq} resources
in individual \code{\link[=tar_target]{tar_target()}} calls will be ignored.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.

In \code{targets} version 0.12.2 and above, resources are inherited one-by-one
in nested fashion from \code{tar_option_get("resources")}.
For example, suppose you set
\code{tar_option_set(resources = tar_resources(aws = my_aws))},
where \code{my_aws} equals \code{tar_resources_aws(bucket = "x", prefix = "y")}.
Then, \verb{tar_target(data, get_data()} will have bucket \code{"x"} and
prefix \code{"y"}. In addition, if \code{new_resources} equals
\verb{tar_resources(aws = tar_resources_aws(bucket = "z")))}, then
\code{tar_target(data, get_data(), resources = new_resources)}
will use the new bucket \code{"z"}, but it will still use the prefix \code{"y"}
supplied through \code{tar_option_set()}. (In \code{targets} 0.12.1 and below,
options like \code{prefix} do not carry over from \code{tar_option_set()} if you
supply non-default resources to \code{tar_target()}.)
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  resources = tar_resources(
    clustermq = tar_resources_clustermq(template = list(n_cores = 2))
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_crew}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
