## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
 collapse = TRUE,
 #dev="png",
 comment = "#>"
)
library(targeted)

## ----simulation---------------------------------------------------------------
m <- lvm(Y ~ A+X+Z, A~X+Z, Z~X)
m <- distribution(m, ~A+Y, binomial.lvm())
d <- sim(m, 1e3, seed=1)
head(d)

## ----syntax-------------------------------------------------------------------
args(ate)

## ----ate1---------------------------------------------------------------------
ate(Y ~ A, data=d, nuisance=~1, propensity=~1)

## ----ate2---------------------------------------------------------------------
ate(Y ~ A | 1 | 1, data=d)

## ----ate_mce------------------------------------------------------------------
mean(sim(intervention(m, "A", 0), 2e5)$Y)
mean(sim(intervention(m, "A", 1), 2e5)$Y)

## ----ate_ipw------------------------------------------------------------------
ate(Y ~ A | 1 | X+Z, data=d)

## ----ate_org------------------------------------------------------------------
ate(Y ~ A | A*(X+Z) | 1, data=d)

## ----ate_ipw_mis--------------------------------------------------------------
ate(Y ~ A | 1 | X, data=d)

## ----ate_or_mis---------------------------------------------------------------
ate(Y ~ A | A*X | 1, data=d)

## ----ate_aipw_mis-------------------------------------------------------------
a <- ate(Y ~ A | A*X | X+Z, data=d)
summary(a)

## ----ate_methods--------------------------------------------------------------
coef(a)
vcov(a)
head(iid(a))

## ----sim2---------------------------------------------------------------------
m <- lvm(y ~ a+x, a~x)
m <- ordinal(m, K=4, ~a)
d <- transform(sim(m, 1e4), a=factor(a))

## ----ate_multiple-------------------------------------------------------------
summary(a2 <- ate(y ~ a | a*x | x, data=d, binary=FALSE))

## ----ate_multiple_contrast----------------------------------------------------
summary(a2, contrast=c(2,4))

## ----ate_multiple_iid---------------------------------------------------------
head(iid(a2))
estimate(a2, function(x) x[2]-x[4])

## -----------------------------------------------------------------------------
sessionInfo()

