% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-nejm.R
\name{summarize_nejm_horz}
\alias{summarize_nejm_horz}
\title{Create a summarization for a categorical set of column versus a numerical row in NEJM style}
\usage{
summarize_nejm_horz(
  table,
  row,
  column,
  cell_style,
  pformat = NULL,
  msd = FALSE,
  quant = c(0.25, 0.5, 0.75),
  overall = NULL,
  test = FALSE,
  useNA = "no",
  ...
)
}
\arguments{
\item{table}{The table object to modify}

\item{row}{The row variable object to use (numerical)}

\item{column}{The column variable to use (categorical)}

\item{cell_style}{list; cell styling functions}

\item{pformat}{numeric, character or function; A formatting directive to be applied to p-values}

\item{msd}{logical; Include mean and standard deviation with quantile statistics}

\item{quant}{numeric; Vector of quantiles to include. Should be an odd number since the middle value is highlighted on display.}

\item{overall}{logical or character; Include overall summary statistics for a categorical column. Character values are assumed to be true and used as column header.}

\item{test}{logical; include statistical test results}

\item{useNA}{character; Specifies whether to include NA counts in the table. The allowed values correspond to never "no" (Default), only if the count is positive "ifany" and even for zero counts "always". An NA column is always excluded.}

\item{...}{absorbs additional arugments. Unused at present.}
}
\value{
The modified table object
}
\description{
Given a row and column object from the parser apply a Kruskal test and output
the results horizontally. 5 X (n + no. categories + test statistic)
}
