% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_summary}
\alias{plot_summary}
\alias{plot_summary.medic}
\alias{plot_summary.summary.medic}
\title{Plot Summary}
\usage{
plot_summary(object, ...)

\method{plot_summary}{medic}(object, only = NULL, clusters = NULL, additional_data = NULL, ...)

\method{plot_summary}{summary.medic}(
  object,
  n_breaks = 5,
  plot_individual = FALSE,
  labels = FALSE,
  alpha_individual = 0.1,
  label_y_value = 0.1,
  ...
)
}
\arguments{
\item{object}{The object containing the summary data.}

\item{...}{Additional arguments passed to the plotting functions.}

\item{only}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{object} and/or \code{additional_data}.

The default \code{NULL} selects all clusterings in \code{object}.}

\item{clusters}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the cluster or clusters in \code{object} one wants to
see summaries of. Names can be used as if they were positions in the data
frame, so expressions like I:IV can be used to select a range of clusters.

The default \code{NULL} selects all clusters in the chosen clusterings of
\code{object}.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}. This is often
used in conjuction with \code{only} to select specific clusterings based on
\code{additional_data}.}

\item{n_breaks}{The number of breaks for the time scale.}

\item{plot_individual}{Logical value indicating whether to plot individual
trajectories.}

\item{labels}{Logical value indicating whether to include labels.}

\item{alpha_individual}{The alpha value for the individual trajectories.}

\item{label_y_value}{A number between 0 and 1 that defines the height of the label text hight.}
}
\value{
A ggplot object.
}
\description{
This function plots the summary of the clustering results.
}
\examples{
\donttest{
clust <- medic(
  complications,
  id = id,
  atc = atc,
  k = 3,
  timing = first_trimester:third_trimester
)

clust |> plot_summary()
clust |> summary() |> plot_summary()

# If the clustering object contains more than one clustering, it is necessary
# to filter the clustering, as only one clustering can be plotted at a time.
clust <- medic(
  complications,
  id = id,
  atc = atc,
  k = 3:5,
  timing = first_trimester:third_trimester
)
clust |> plot_summary(only = k == 4)
clust |> summary(only = k == 4) |> plot_summary()
}
}
\seealso{
\code{\link{summary}}

\code{\link{plot_cluster_frequency}}

\code{\link{plot_medication_frequency}}

\code{\link{plot_comedication_count}}

\code{\link{plot_timing_trajectory}}

\code{\link{plot_timing_atc_group}}
}
