% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-spot.R
\docType{methods}
\name{plot_spot}
\alias{plot_spot}
\alias{plot_spot-method}
\alias{plot_spot,CountMatrix-method}
\alias{plot_spot,AbundanceMatrix-method}
\alias{plot_spot,SimilarityMatrix-method}
\alias{plot_spot,OccurrenceMatrix-method}
\title{Spot Plot}
\usage{
plot_spot(object, ...)

\S4method{plot_spot}{CountMatrix}(object, threshold = NULL)

\S4method{plot_spot}{AbundanceMatrix}(object, threshold = NULL)

\S4method{plot_spot}{SimilarityMatrix}(object)

\S4method{plot_spot}{OccurrenceMatrix}(object)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Currently not used.}

\item{threshold}{A \code{\link{function}} that takes a numeric vector as
argument and returns a numeric threshold value.
If \code{NULL} (the default), no threshold is computed.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plots a spot matrix.
}
\details{
The spot matrix can be considered as a variant of the
 \link[=plot_bertin]{Bertin diagram} where the data are first transformed to
 relative frequencies.
}
\note{
Adapted from Dan Gopstein's original
 \href{https://dgopstein.github.io/articles/spot-matrix/}{idea}.
 Credit should be given to him.
}
\examples{
## Plot spot diagram...

## ...of count data...
mississippi_count <- as_count(mississippi)
### ...without threshod
plot_spot(mississippi_count)
### ...with the  column means as threshold
plot_spot(mississippi_count, threshold = mean)
### ...with the column medians as threshold
plot_spot(mississippi_count, threshold = median)

## ...of a similarity matrix
sim <- similarity(mississippi_count, method = "brainerd")
plot_spot(sim)

## ...of a co-occurrence matrix
occ <- as_occurrence(mississippi)
plot_spot(occ)
}
\seealso{
Other plot: \code{\link{plot_bar}},
  \code{\link{plot_date}}, \code{\link{plot_diversity}},
  \code{\link{plot_line}}, \code{\link{plot_matrix}}
}
\author{
N. Frerebeau
}
\concept{plot}
