% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chords.R
\name{dyad}
\alias{dyad}
\title{Construct a dyad}
\usage{
dyad(
  notes,
  interval,
  reverse = FALSE,
  octaves = c("tick", "integer"),
  accidentals = c("flat", "sharp"),
  key = NULL
)
}
\arguments{
\item{notes}{character, a noteworthy string, single notes only, no chords.
Number of timesteps must equal the length of \code{interval}.}

\item{interval}{integer or character vector; semitones or interval ID,
respectively. See details.}

\item{reverse}{logical, reverse the transposition direction. Useful when
\code{interval} is character.}

\item{octaves, accidentals, key}{See \code{\link[=transpose]{transpose()}}.}
}
\value{
character
}
\description{
Construct a dyad given one note, an interval, and a direction.
}
\details{
The \code{interval} may be specified by semitones of by common interval name
or abbreviation. See examples.
For a complete list of valid interval names and abbreviations see
\code{\link[=mainIntervals]{mainIntervals()}}.
\code{key} enforces the use of sharps or flats. This function is based on
\code{transpose()}.
\code{notes} and \code{interval} may be vectors, but must be equal length.
Recycling occurs only if one argument is scalar.
}
\examples{
dyad("a", 4)
x <- c("minor third", "m3", "augmented second", "A2")
dyad("a", x)
dyad("c'", x, reverse = TRUE)

x <- c("M3", "m3", "m3", "M3", "M3", "m3", "m3")
dyad(letters[c(3:7, 1, 2)], x)

x <- c("P1", "m3", "M3", "P4", "P5", "P8", "M9")
dyad("c", x)
dyad("c", x, reverse = TRUE)
dyad("d e", "m3")
}
\seealso{
\code{\link[=mainIntervals]{mainIntervals()}}
}
