% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phrase.R
\name{simplify_phrase}
\alias{simplify_phrase}
\title{Simplify the LilyPond syntax of a phrase}
\usage{
simplify_phrase(phrase)
}
\arguments{
\item{phrase}{a phrase object.}
}
\value{
character
}
\description{
This function can be used to simplify the LilyPond syntax of a phrase. Not
intended for direct use. See details.
}
\details{
This function not intended to be used directly, but is available so that you
can see how LilyPond syntax for phrases will be transformed by default in
the process of creating a LilyPond file. This function is used by the
\code{lilypond} function and associated \code{render_*} functions. When
using \code{lilypond} directly, this can be controlled by the
\code{simplify} argument.

The result of this function is a character string containing simpler, more
efficient LilyPond syntax. It can be coerced back to a phrase with
\code{as_phrase}, but its print method colors will no longer display
properly. More importantly, this simplification removes any possibility of
transforming the phrase back to its original inputs. The more complex but
nicely structured original representation does a better job at maintaining
reasonable possibility of one to one transformation between a phrase object
and the inputs that it was built from.
}
\examples{
notes <- "a~ a b c' c'e'g'~ c'e'g'"
info <- "8.. 8..-. 8- 8-^ 4.^ 4."
(x <- p(notes, info))
as_phrase(simplify_phrase(x))

(x <- p(notes, info, 5))
as_phrase(simplify_phrase(x))
}
