% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track}
\alias{track}
\title{Create a music track}
\usage{
track(phrase, tuning = "standard", voice = 1L,
  music_staff = "treble_8", ms_transpose = 0, ms_key = NA,
  no_tab = FALSE)
}
\arguments{
\item{phrase}{a phrase object.}

\item{tuning}{character, space-delimited pitches describing the instrument
string tuning or a predefined tuning ID (see \code{\link{tunings}}).
Defaults to standard guitar tuning. Tick or integer octave numbering
accepted for custom tuning entries.}

\item{voice}{integer, ID indicating the unique voice \code{phrase} belongs
to within a single track (another track may share the same tab/music staff
but have a different voice ID).}

\item{music_staff}{add a standard sheet music staff above the tablature
staff. See details.}

\item{ms_transpose}{integer, positive or negative number of semitones to
transpose an included music staff relative to the tablature staff.
See details.}

\item{ms_key}{character, specify the new key signature for a transposed music
staff. See details.}

\item{no_tab}{logical, suppress the default guitar tablature so that only a
standard music staff is associated with the track. Ignored if
\code{music_staff = NA}.}
}
\value{
a track table.
}
\description{
Create a music track from a collection of musical phrases.
}
\details{
Musical phrases generated by \code{\link{phrase}} are fortified in a track
table. All tracks are stored as track tables, one per row, even if that
table consists of a single track.
\code{track} creates a single-entry track table.
See \code{\link{trackbind}} for merging single tracks into a multi-track
table. This is simply row binding that properly preserves phrase and track
classes.

The default for an additional music staff is \code{"treble_8"} for 8va
treble clef, which is commonly displayed in quality guitar tablature above
the tablature staff to include precise rhythm and timing information.
Note that guitar is a transposing instrument. For this reason, the default
ID is \code{"treble_8"}, not \code{"treble"}.
Set \code{music_staff = NA} to suppress the additional music staff above
the tablature staff.
This is appropriate for simple patterns where there are already multiple
tracks and the additional space required for two staves per instrument is
unnecessary and wasteful.

The arguments \code{ms_transpose} and \code{ms_key} pertain to the
transposition of the music staff relative to the tab staff if
\code{music_staff} is not \code{NA}. These arguments default to 0 and
\code{NA}, respectively.
The transposition and new key are simply stored in the \code{ms_transpose}
and \code{ms_key} columns in the resulting track table.
This information is used by \code{lilypond} or \code{tab} to transpose the
music staff relative to the tab staff at the time of LilyPond file
generation.
Non-zero semitone transposition works without providing an explicit new key
signature, but it is recommended to specify because it helps ensure the
correct selection of accidentals in the output.
As with the \code{\link{transpose}} function, you can simply specify
\code{key = "flat"} or \code{key = "sharp"}. The exact key signature is not
required; it is merely more clear and informative for the user.
}
\examples{
x <- phrase("c ec'g' ec'g'", "4 4 2", "5 432 432")
track(x)
}
