% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablet.R
\name{groupwise.data.frame}
\alias{groupwise.data.frame}
\title{Calculate Widgets With and Without Groups}
\usage{
\method{groupwise}{data.frame}(
  x,
  fun = list(sum ~ sum(x, na.rm = TRUE), pct ~ signif(digits = 3, sum/n * 100), ave ~
    signif(digits = 3, mean(x, na.rm = TRUE)), std ~ signif(digits = 3, sd(x, na.rm =
    TRUE)), med ~ signif(digits = 3, median(x, na.rm = TRUE)), min ~ signif(digits = 3,
    min(x, na.rm = TRUE)), max ~ signif(digits = 3, max(x, na.rm = TRUE))),
  fac = list(` ` ~ sum + " (" + pct + "\%" + ")"),
  num = list(`Mean (SD)` ~ ave + " (" + std + ")", `Median (range)` ~ med + " (" + min +
    ", " + max + ")"),
  ...
)
}
\arguments{
\item{x}{data.frame}

\item{fun}{passed to groupfull() and groupless()}

\item{fac}{passed to groupfull() and groupless()}

\item{num}{passed to groupfull() and groupless()}

\item{...}{passed to groupfull() and groupless()}
}
\value{
class 'groupwise', arranged by groups:
\item{_tablet_name}{observation identifier}
\item{_tablet_level}{factor level or LHS of formulas in 'num'}
\item{_tablet_N}{number of records}
\item{_tablet_n}{number of records in group}
\item{_tablet_groupfull}{the LHS of formulas in 'fac' and 'num'}
\item{_tablet_groupless}{the LHS of formulas in 'fac' and 'num'}
}
\description{
Calculates widgets with and without groups.
Supplies 'groupfull' and 'groupless' (prefixed) columns instead of 'widgets'.
}
\keyword{internal}
