% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screenIsotopeData.R
\name{screenIsotopeData}
\alias{screenIsotopeData}
\title{Function to plot and screen stable isotope data with one or more baselines.}
\usage{
screenIsotopeData(isotopeData = NULL, density = "both",
  consumer = "Consumer", b1 = "Pelagic baseline",
  b2 = "Benthic baseline", legend = c(1.15, 1.15), title = NULL, ...)
}
\arguments{
\item{isotopeData}{an isotopeData class object.}

\item{density}{string representing whether the density function is plotted.
Accepted characters are "both" in which case will plot the density function
above and to the right, "right", "above" or "none".}

\item{consumer}{string representing the consumer.}

\item{b1}{string representing baseline 1.}

\item{b2}{string representing baseline 2.}

\item{legend}{coordinates representing where to locate the legend.}

\item{title}{string representing title.}

\item{...}{additional arguments passed to this function.}
}
\value{
none
}
\description{
This function receives a named list of vectors (isotopeData class object),
and plots a biplot with 2 sources and a consumer. The user can states whether
he/she wants a density function plotted above, to the right, at both sides or
does not want it to be plotted.
}
\examples{
a <- generateTPData()
screenIsotopeData(a)
}
