/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.Const;
import blbutil.Filter;
import blbutil.InputIt;
import blbutil.IntPair;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import haplotype.BasicSampleHapPairs;
import haplotype.BitHapPair;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import ibd.IbdSegment;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import main.AlleleProbs;
import main.BasicGenotypeValues;
import main.ConstrainedAlleleProbs;
import main.CurrentData;
import main.GeneticMap;
import main.GenotypeValues;
import main.MainHelper;
import main.NuclearFamilies;
import main.Par;
import main.PlinkGeneticMap;
import main.RunStats;
import main.WindowWriter;
import vcf.AllData;
import vcf.BrefIt;
import vcf.Data;
import vcf.FilterUtil;
import vcf.GL;
import vcf.IntervalVcfIt;
import vcf.Marker;
import vcf.Markers;
import vcf.RefIt;
import vcf.TargetData;
import vcf.VcfEmission;
import vcf.VcfIt;
import vcf.VcfRecord;

public class Main {
    public static final String program = "beagle.21Jan17.6cc.jar (version 4.1)";
    public static final String command = "java -jar beagle.21Jan17.6cc.jar";
    public static final String copyright = "Copyright (C) 2014-2015 Brian L. Browning";
    public static final String shortHelp = "beagle.21Jan17.6cc.jar (version 4.1)" + Const.nl + "Copyright (C) 2014-2015 Brian L. Browning" + Const.nl + "Enter \"java -jar beagle.21Jan17.6cc.jar\" for a " + "summary of command line " + "arguments.";
    private final Par par;
    private final GeneticMap genMap;
    private final Data data;
    private final RunStats runStats;
    private final WindowWriter windowOut;

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.US);
        if (stringArray.length == 0) {
            System.out.println(program);
            System.out.println(copyright);
            System.out.println(Par.usage());
            System.exit(0);
        }
        Par par = Main.parameters(stringArray);
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(par.nthreads()));
        RunStats runStats = new RunStats(par);
        runStats.printStartInfo();
        GeneticMap geneticMap = Main.geneticMap(par);
        try (Data data = par.ref() == null ? Main.nonRefData(par) : Main.allData(par);
             WindowWriter windowWriter = new WindowWriter(data.targetSamples(), par.out());){
            Main main = new Main(par, data, geneticMap, windowWriter, runStats);
            main.phaseData();
            runStats.printSummaryAndClose(data.nTargetMarkersSoFar(), data.nMarkersSoFar());
        }
    }

    private Main(Par par, Data data, GeneticMap geneticMap, WindowWriter windowWriter, RunStats runStats) {
        assert (par != null);
        assert (data != null);
        assert (windowWriter != null);
        assert (runStats != null);
        this.par = par;
        this.genMap = geneticMap;
        this.data = data;
        this.runStats = runStats;
        this.windowOut = windowWriter;
    }

    private void phaseData() {
        NuclearFamilies nuclearFamilies = new NuclearFamilies(this.data.targetSamples(), this.par.ped());
        this.runStats.printSampleSummary(nuclearFamilies, this.data);
        MainHelper mainHelper = new MainHelper(this.par, this.genMap, this.runStats);
        SampleHapPairs sampleHapPairs = null;
        int n = 0;
        while (this.data.canAdvanceWindow()) {
            this.advanceWindow(n, this.par.window());
            CurrentData currentData = new CurrentData(this.par, this.genMap, this.data, sampleHapPairs, nuclearFamilies);
            GenotypeValues genotypeValues = Main.gv(this.par, currentData);
            SampleHapPairs sampleHapPairs2 = mainHelper.phase(currentData, genotypeValues);
            if (genotypeValues != null) {
                this.windowOut.printGV(currentData, genotypeValues);
            } else {
                Map<IntPair, List<IbdSegment>> map = mainHelper.refinedIbd(currentData, sampleHapPairs2);
                AlleleProbs alleleProbs = mainHelper.LSImpute(currentData, sampleHapPairs2);
                this.printOutput(currentData, sampleHapPairs2, alleleProbs, map);
            }
            sampleHapPairs = this.overlapHaps(currentData, sampleHapPairs2);
            n = currentData.nMarkers() - currentData.nextOverlapStart();
        }
    }

    private static GenotypeValues gv(Par par, CurrentData currentData) {
        BasicGenotypeValues basicGenotypeValues = null;
        if (par.gt() == null) {
            basicGenotypeValues = new BasicGenotypeValues(currentData.targetMarkers(), currentData.targetSamples());
            if (par.gtgl() != null) {
                Main.initializeGV(basicGenotypeValues, currentData.targetGL());
            }
        }
        return basicGenotypeValues;
    }

    private static void initializeGV(GenotypeValues genotypeValues, GL gL) {
        assert (genotypeValues.markers().equals(gL.markers()));
        assert (genotypeValues.samples().equals(gL.samples()));
        int n = gL.nMarkers();
        int n2 = gL.nSamples();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = gL.allele1(i, j);
                int n4 = gL.allele2(i, j);
                if (n3 < 0 || n4 < 0) continue;
                int n5 = VcfRecord.gtIndex(n3, n4);
                genotypeValues.add(i, j, n5, 1.0);
            }
        }
    }

    private void printOutput(CurrentData currentData, SampleHapPairs sampleHapPairs, AlleleProbs alleleProbs, Map<IntPair, List<IbdSegment>> map) {
        assert (this.par.gt() != null);
        boolean bl = currentData.nTargetMarkers() < currentData.nMarkers();
        boolean[] blArray = Main.isImputed(currentData);
        int n = currentData.prevSpliceStart();
        int n2 = currentData.nextSpliceStart();
        boolean bl2 = bl;
        boolean bl3 = bl && this.par.gprobs();
        int n3 = this.par.nthreads();
        if (bl) {
            alleleProbs = new ConstrainedAlleleProbs(sampleHapPairs, alleleProbs, currentData.targetMarkerIndices());
        }
        this.windowOut.print(alleleProbs, blArray, n, n2, bl2, bl3, n3);
        if (this.par.ibd()) {
            this.windowOut.printIbd(currentData, map);
        }
    }

    private static boolean[] isImputed(CurrentData currentData) {
        boolean[] blArray = new boolean[currentData.nMarkers()];
        if (currentData.nTargetMarkers() < blArray.length) {
            for (int i = 0; i < blArray.length; ++i) {
                if (currentData.targetMarkerIndex(i) != -1) continue;
                blArray[i] = true;
            }
        }
        return blArray;
    }

    private SampleHapPairs overlapHaps(CurrentData currentData, SampleHapPairs sampleHapPairs) {
        int n = currentData.nextTargetOverlapStart();
        int n2 = currentData.nextTargetSpliceStart();
        if (currentData.nextOverlapStart() == currentData.nextSpliceStart()) {
            return null;
        }
        int n3 = sampleHapPairs.nSamples();
        int n4 = n2 - n;
        Markers markers = sampleHapPairs.markers().restrict(n, n2);
        Samples samples = sampleHapPairs.samples();
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(n3);
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                nArray[j] = sampleHapPairs.allele1(n + j, i);
                nArray2[j] = sampleHapPairs.allele2(n + j, i);
            }
            arrayList.add(new BitHapPair(markers, samples, i, nArray, nArray2));
        }
        return new BasicSampleHapPairs(sampleHapPairs.samples(), arrayList);
    }

    private static Data nonRefData(Par par) {
        SampleFileIt<VcfEmission> sampleFileIt;
        Filter<String> filter = FilterUtil.sampleFilter(par.excludesamples());
        Filter<Marker> filter2 = FilterUtil.markerFilter(par.excludemarkers());
        ChromInterval chromInterval = ChromInterval.parse(par.chrom());
        if (par.gt() != null) {
            assert (par.gl() == null && par.gtgl() == null);
            InputIt inputIt = InputIt.fromGzipFile(par.gt());
            sampleFileIt = VcfIt.create(inputIt, filter, filter2, VcfIt.toBitSetGT);
        } else if (par.gl() != null) {
            assert (par.gt() == null && par.gtgl() == null);
            InputIt inputIt = InputIt.fromGzipFile(par.gl());
            sampleFileIt = VcfIt.create(inputIt, filter, filter2, VcfIt.toGLRec);
        } else {
            assert (par.gt() == null && par.gl() == null);
            InputIt inputIt = InputIt.fromGzipFile(par.gtgl());
            sampleFileIt = VcfIt.create(inputIt, filter, filter2, VcfIt.toGTGLRec);
        }
        if (chromInterval != null) {
            sampleFileIt = new IntervalVcfIt<VcfEmission>(sampleFileIt, chromInterval);
        }
        return TargetData.targetData(sampleFileIt);
    }

    private static Data allData(Par par) {
        SampleFileIt<VcfEmission> sampleFileIt;
        SampleFileIt<VcfEmission> sampleFileIt2;
        InputIt inputIt;
        File file;
        Filter<String> filter = FilterUtil.sampleFilter(par.excludesamples());
        Filter<Marker> filter2 = FilterUtil.markerFilter(par.excludemarkers());
        ChromInterval chromInterval = ChromInterval.parse(par.chrom());
        if (par.gt() != null) {
            assert (par.gl() == null && par.gtgl() == null);
            file = par.gt();
            inputIt = InputIt.fromGzipFile(file);
            sampleFileIt2 = VcfIt.create(inputIt, filter, filter2, VcfIt.toBitSetGT);
        } else if (par.gl() != null) {
            assert (par.gt() == null && par.gtgl() == null);
            file = par.gl();
            inputIt = InputIt.fromGzipFile(file);
            sampleFileIt2 = VcfIt.create(inputIt, filter, filter2, VcfIt.toGLRec);
        } else {
            assert (par.gt() == null && par.gl() == null && par.gtgl() != null);
            file = par.gtgl();
            inputIt = InputIt.fromGzipFile(file);
            sampleFileIt2 = VcfIt.create(inputIt, filter, filter2, VcfIt.toGTGLRec);
        }
        if (!par.impute() || par.gt() == null) {
            filter2 = Main.restrictToVcfMarkers(file, filter2, chromInterval);
        }
        if (par.ref().toString().endsWith(".bref")) {
            sampleFileIt = new BrefIt(par.ref(), filter2);
        } else {
            inputIt = InputIt.fromGzipFile(par.ref());
            sampleFileIt = RefIt.create(inputIt, filter, filter2, 1000);
        }
        if (chromInterval != null) {
            sampleFileIt2 = new IntervalVcfIt<VcfEmission>(sampleFileIt2, chromInterval);
            sampleFileIt = new IntervalVcfIt<VcfEmission>(sampleFileIt, chromInterval);
        }
        return AllData.allData(sampleFileIt, sampleFileIt2);
    }

    private static Filter<Marker> restrictToVcfMarkers(File file, Filter<Marker> filter, ChromInterval chromInterval) {
        HashSet<Marker> hashSet = new HashSet<Marker>(50000);
        try (InputIt inputIt = InputIt.fromGzipFile(file);){
            Filter<String> filter2 = null;
            SampleFileIt<VcfRecord> sampleFileIt = VcfIt.create(inputIt, filter2, filter, VcfIt.toGTGLRec);
            if (chromInterval != null) {
                sampleFileIt = new IntervalVcfIt<VcfRecord>(sampleFileIt, chromInterval);
            }
            while (sampleFileIt.hasNext()) {
                hashSet.add(((VcfRecord)sampleFileIt.next()).marker());
            }
            sampleFileIt.close();
        }
        return Filter.includeFilter(hashSet);
    }

    private static GeneticMap geneticMap(Par par) {
        if (par.map() == null) {
            return null;
        }
        String string = Main.extractChrom(par.chrom());
        if (string == null) {
            return PlinkGeneticMap.fromPlinkMapFile(par.map());
        }
        return PlinkGeneticMap.fromPlinkMapFile(par.map(), string);
    }

    private static String extractChrom(String string) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf(58);
            if (n == -1) {
                return string;
            }
            return new String(string.substring(0, n));
        }
        return null;
    }

    private static Par parameters(String[] stringArray) {
        String string;
        Par par = new Par(stringArray);
        Main.checkForOneInputFile(par);
        Main.checkOutputPrefix(par);
        if (par.overlap() >= par.window() / 2) {
            string = shortHelp + Const.nl + Const.nl + "ERROR: The \"window\" parameter must be at least " + "two times the \"overlap\" parameter" + Const.nl + "Exiting program.";
            Utilities.exit(string);
        }
        if (par.chrom() != null && ChromInterval.parse(par.chrom()) == null) {
            string = shortHelp + Const.nl + Const.nl + "ERROR: invalid \"chrom\" parameter: \"" + par.chrom() + "\"" + Const.nl + "Exiting program.";
            Utilities.exit(string);
        }
        if (par.ibd() && par.ref() != null && par.impute()) {
            string = shortHelp + Const.nl + Const.nl + "ERROR: The \"impute=false\" argument is " + "required when a reference panel" + Const.nl + "       is specified and \"ibd=true\"." + Const.nl + "Exiting program.";
            Utilities.exit(string);
        }
        return par;
    }

    private static void checkForOneInputFile(Par par) {
        int n = 0;
        if (par.gt() != null) {
            ++n;
        }
        if (par.gl() != null) {
            ++n;
        }
        if (par.gtgl() != null) {
            ++n;
        }
        if (n != 1) {
            String string = "ERROR: exactly one \"gt\", \"gl\" or \"gtgl\" parameter is required.";
            Utilities.exit(Par.usage() + string);
        }
    }

    private static void checkOutputPrefix(Par par) {
        String string;
        Object object;
        File file = new File(par.out());
        if (file.isDirectory()) {
            object = "ERROR: \"out\" parameter cannot be a directory: \"" + par.out() + "\"";
            Utilities.exit(Par.usage() + (String)object);
        }
        if (((File)(object = new File(par.out() + ".vcf.gz"))).equals(par.ref())) {
            string = "ERROR: VCF output file equals input file: " + par.ref();
            Utilities.exit(Par.usage() + string);
        }
        if (((File)object).equals(par.gt())) {
            string = "ERROR: VCF output file equals input file: " + par.gt();
            Utilities.exit(Par.usage() + string);
        }
        if (((File)object).equals(par.gl())) {
            string = "ERROR: VCF output file equals input file: " + par.gl();
            Utilities.exit(Par.usage() + string);
        }
        if (((File)object).equals(par.gtgl())) {
            string = "ERROR: VCF output file equals input file: " + par.gtgl();
            Utilities.exit(Par.usage() + string);
        }
    }

    private void advanceWindow(int n, int n2) {
        if (this.data.canAdvanceWindow()) {
            this.data.advanceWindow(n, n2);
        }
        this.runStats.printWindowUpdate(this.data);
    }
}

