/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.BasicSampleHapPairs;
import haplotype.BitHapPair;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import java.util.ArrayList;
import vcf.Marker;
import vcf.Markers;

public final class SampleHapPairsSplicer {
    private SampleHapPairsSplicer() {
    }

    public static SampleHapPairs spliceNext(SampleHapPairs sampleHapPairs, SampleHapPairs sampleHapPairs2, int n, int n2) {
        SampleHapPairsSplicer.checkSamples(sampleHapPairs, sampleHapPairs2);
        SampleHapPairsSplicer.checkOverlap(sampleHapPairs, sampleHapPairs2, n, n2);
        if (n2 == 0) {
            return sampleHapPairs2;
        }
        return new SplicedHapPairs(sampleHapPairs, sampleHapPairs2, n, n2);
    }

    private static void checkSamples(SampleHapPairs sampleHapPairs, SampleHapPairs sampleHapPairs2) {
        if (!sampleHapPairs2.samples().equals(sampleHapPairs.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static void checkOverlap(SampleHapPairs sampleHapPairs, SampleHapPairs sampleHapPairs2, int n, int n2) {
        if (n2 < 0 || n2 > sampleHapPairs.nMarkers() || n2 > sampleHapPairs2.nMarkers()) {
            throw new IllegalArgumentException("overlap: " + n2);
        }
        if (n > n2) {
            String string = "nextStart=" + n + " overlap=" + n2;
            throw new IllegalArgumentException(string);
        }
        int n3 = sampleHapPairs.nMarkers() - n2;
        for (int i = 0; i < n2; ++i) {
            Marker marker;
            Marker marker2 = sampleHapPairs.marker(n3 + i);
            if (marker2.equals(marker = sampleHapPairs2.marker(i))) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
    }

    private static SampleHapPairs restrict(SampleHapPairs sampleHapPairs, int n, int n2) {
        int n3 = n2 - n;
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(n3);
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        Markers markers = sampleHapPairs.markers().restrict(n, n2);
        int n4 = sampleHapPairs.nSamples();
        for (int i = 0; i < n4; ++i) {
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                byArray[n5] = sampleHapPairs.allele1(n + n5, i);
                byArray2[n5] = sampleHapPairs.allele2(n + n5, i);
            }
            n5 = sampleHapPairs.idIndex(i);
            arrayList.add(new BitHapPair(markers, n5, byArray, byArray2));
        }
        return new BasicSampleHapPairs(sampleHapPairs.samples(), arrayList);
    }

    private static boolean[] switchHapOrder(SampleHapPairs sampleHapPairs, SampleHapPairs sampleHapPairs2, int n, int n2) {
        boolean[] blArray = new boolean[sampleHapPairs2.nHapPairs()];
        int n3 = sampleHapPairs2.nHapPairs();
        for (int i = 0; i < n3; ++i) {
            boolean bl = true;
            int n4 = 2 * n2;
            for (int j = 1; j <= n4 && bl; ++j) {
                byte by;
                int n5 = n + ((j & 1) == 0 ? -j : j) / 2;
                if (n5 < 0 || n5 >= n2) continue;
                int n6 = sampleHapPairs.nMarkers() - n2 + n5;
                byte by2 = sampleHapPairs2.allele1(n5, i);
                if (by2 == (by = sampleHapPairs2.allele2(n5, i))) continue;
                assert (by2 >= 0 && by >= 0);
                byte by3 = sampleHapPairs.allele1(n6, i);
                byte by4 = sampleHapPairs.allele2(n6, i);
                if (by2 == by3 && by == by4) {
                    blArray[i] = false;
                    bl = false;
                    continue;
                }
                if (by2 != by4 || by != by3) continue;
                blArray[i] = true;
                bl = false;
            }
        }
        return blArray;
    }

    private static class SplicedHapPairs
    implements SampleHapPairs {
        private final SampleHapPairs splicedPrev;
        private final SampleHapPairs next;
        private final boolean[] hapPairIsSwitched;

        private SplicedHapPairs(SampleHapPairs sampleHapPairs, SampleHapPairs sampleHapPairs2, int n, int n2) {
            int n3 = sampleHapPairs.nMarkers();
            assert (n2 <= n3);
            this.splicedPrev = SampleHapPairsSplicer.restrict(sampleHapPairs, n3 - n2, n3 - n2 + n);
            this.next = sampleHapPairs2;
            this.hapPairIsSwitched = SampleHapPairsSplicer.switchHapOrder(sampleHapPairs, sampleHapPairs2, n, n2);
        }

        @Override
        public byte allele1(int n, int n2) {
            if (n < this.splicedPrev.nMarkers()) {
                return this.splicedPrev.allele1(n, n2);
            }
            if (this.hapPairIsSwitched[n2]) {
                return this.next.allele2(n, n2);
            }
            return this.next.allele1(n, n2);
        }

        @Override
        public byte allele2(int n, int n2) {
            if (n < this.splicedPrev.nMarkers()) {
                return this.splicedPrev.allele2(n, n2);
            }
            if (this.hapPairIsSwitched[n2]) {
                return this.next.allele1(n, n2);
            }
            return this.next.allele2(n, n2);
        }

        @Override
        public byte allele(int n, int n2) {
            int n3 = n2 / 2;
            if ((n2 & 1) == 0) {
                return this.allele1(n, n3);
            }
            return this.allele2(n, n3);
        }

        @Override
        public Markers markers() {
            return this.next.markers();
        }

        @Override
        public Marker marker(int n) {
            return this.next.marker(n);
        }

        @Override
        public int nHaps() {
            return 2 * this.nSamples();
        }

        @Override
        public int nHapPairs() {
            return this.next.nSamples();
        }

        @Override
        public Samples samples() {
            return this.next.samples();
        }

        @Override
        public int idIndex(int n) {
            return this.next.idIndex(n);
        }

        @Override
        public int nSamples() {
            return this.next.nSamples();
        }

        @Override
        public int nMarkers() {
            return this.next.nMarkers();
        }
    }
}

