% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{loocv}
\alias{loocv}
\title{Leave-one-out cross-validation}
\usage{
loocv(fit)
}
\arguments{
\item{fit}{an object of class \code{lm}.}
}
\value{
This function returns a numeric value representing root mean squared 
error (RMSE) of leave-one-out cross-validation (LOOCV).
}
\description{
This function calculates root mean squared error (RMSE) for
leave-one-out cross-validation of linear regression estimated via
least squares method.
}
\details{
Fast analytical formula is used.
}
\examples{
set.seed(123)
# Generate data according to linear regression
n <- 100
eps <- rnorm(n)
x <- runif(n)
y <- x + eps
# Estimate the model
model <- lm(y ~ x)
# Perform cross-validation
loocv(model)
}
