% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle.polygon.R
\name{circle.polygon}
\alias{circle.polygon}
\title{Circle Polygon (on Earth)}
\usage{
circle.polygon(
  x,
  y,
  radius,
  brng.limits = 0,
  sides = 1,
  by.length = TRUE,
  units = "nm",
  ellipsoid = datum(),
  dist.method = "lawofcosines",
  destination.type = "ellipsoid",
  poly.type = "cart.earth"
)
}
\arguments{
\item{x, y}{number specifying the coordinates of the center of the circle in decimal degrees. 
If \code{poly.type} is "simple.earth" or "complex.earth", this will be longitude and 
latitude respectively.}

\item{radius}{radius of sphere.}

\item{brng.limits}{number, or vector of two numbers. If one value is given, it is used as the starting 
bearing in degrees for the first point of the circle. If a vector of two values is given, then they 
are used as the start and end bearings of arc.}

\item{sides}{number that represents either length of sides or number of sides, as specified by the 
'by.length' argument.}

\item{by.length}{logical. If \code{TRUE}, then \code{sides} is the length of sides, if 
\code{FALSE}, then \code{sides} is number of sides.}

\item{units}{character for units of distance: Can be "km" (kilometers), "nm" (nautical miles), 
"mi" (statute miles).}

\item{ellipsoid}{ellipsoid model parameters as returned from a call to \code{\link{datum}}.}

\item{dist.method}{character specifying method for calculating distance for \code{type} = "cart.earth". 
See \code{method} argument of \code{\link{distance}} for more information.}

\item{destination.type}{character specifying type of surface for \code{type} = "gc.earth". 
See \code{type} argument of \code{\link{destination}} for more information.}

\item{poly.type}{character specifying the type of polygon calculation to use. Can be one of "cartesian" 
using basic cartesian coordinates, "cart.earth" for a simple polygon on the earth's surface treating
latitude and longitude as cartesian coordinates, or "gc.earth" for a more precise calculation 
keeping a constant great-circle radius.}
}
\value{
A matrix representing the desired circle polygon centered at lat, lon of radius.
}
\description{
Creates a circular polygon (optionally on the earth) centered at a given point with a constant radius.
}
\examples{
cart.earth <- circle.polygon(-117.24, 32.86, 40, poly.type = "cart.earth")

lat.range <- c(32, 34)
lon.range <- c(-118.5, -116)

op <- par(mar = c(3, 5, 5, 5) + 0.1, oma = c(1, 1, 1, 1))

maps::map("mapdata::worldHires", fill = TRUE, col = "wheat3", xlim = lon.range, ylim = lat.range)
points(-117.24, 32.86, pch = 19, col = "red")
polygon(cart.earth, border = "red", lwd = 3)
lat.lon.axes(n = 3)
box(lwd = 2)
mtext("poly.type = 'cart.earth'", line = 3)

par(op)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
