% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perpDist.R
\name{perpDist}
\alias{perpDist}
\title{Perpendicular Distance}
\usage{
perpDist(pts, line)
}
\arguments{
\item{pts}{two column matrix of points.}

\item{line}{either a 2x2 matrix of points defining line or
two element vector giving intercept and slope of line.}
}
\description{
Calculate the perpendicular distance of a matrix 
  of points to a line.
}
\examples{
ran.pts <- matrix(runif(10), ncol = 2)
x <- perpDist(ran.pts, c(0, 1))
x

plot.new()
plot.window(xlim = c(0, 1), ylim = c(0, 1), asp = 1)
abline(a = 0, b = 1)
points(ran.pts[, 1], ran.pts[, 2])
segments(ran.pts[, 1], ran.pts[, 2], x[, 1], x[, 2], lty = "dashed")
points(x[, 1], x[, 2], col = "red")
axis(1, pos = 0)
axis(2, pos = 0)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
