% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers_robets.R
\name{tidiers_robets}
\alias{tidiers_robets}
\alias{sw_tidy.robets}
\alias{sw_glance.robets}
\alias{sw_augment.robets}
\alias{sw_tidy_decomp.robets}
\title{Tidying methods for robets (Robust Error, Trend, Seasonal) exponential smoothing
modeling of time series}
\usage{
\method{sw_tidy}{robets}(x, ...)

\method{sw_glance}{robets}(x, ...)

\method{sw_augment}{robets}(x, data = NULL, timetk_idx = FALSE, rename_index = "index", ...)

\method{sw_tidy_decomp}{robets}(x, timetk_idx = FALSE, rename_index = "index", ...)
}
\arguments{
\item{x}{An object of class "robets"}

\item{...}{Not used.}

\item{data}{Used with \code{sw_augment} only.
\code{NULL} by default which simply returns augmented columns only.
User can supply the original data, which returns the data + augmented columns.}

\item{timetk_idx}{Used with \code{sw_augment} and \code{sw_tidy_decomp}.
When \code{TRUE}, uses a timetk index (irregular, typically date or datetime) if present.}

\item{rename_index}{Used with \code{sw_augment} and \code{sw_tidy_decomp}.
A string representing the name of the index generated.}
}
\value{
\strong{\code{sw_tidy()}} returns one row for each model parameter,
with two columns:
\itemize{
\item \code{term}: The smoothing parameters (alpha, gamma) and the initial states
(l, s0 through s10)
\item \code{estimate}: The estimated parameter value
}

\strong{\code{sw_glance()}} returns one row with the columns
\itemize{
\item \code{model.desc}: A description of the model including the
three integer components (p, d, q) are the AR order,
the degree of differencing, and the MA order.
\item \code{sigma}: The square root of the estimated residual variance
\item \code{logLik}: The data's log-likelihood under the model
\item \code{AIC}: The Akaike Information Criterion
\item \code{BIC}: The Bayesian Information Criterion
\item \code{ME}: Mean error
\item \code{RMSE}: Root mean squared error
\item \code{MAE}: Mean absolute error
\item \code{MPE}: Mean percentage error
\item \code{MAPE}: Mean absolute percentage error
\item \code{MASE}: Mean absolute scaled error
\item \code{ACF1}: Autocorrelation of errors at lag 1
}

\strong{\code{sw_augment()}} returns a tibble with the following time series attributes:
\itemize{
\item \code{index}: An index is either attempted to be extracted from the model or
a sequential index is created for plotting purposes
\item \code{.actual}: The original time series
\item \code{.fitted}: The fitted values from the model
\item \code{.resid}: The residual values from the model
}

\strong{\code{sw_tidy_decomp()}} returns a tibble with the following time series attributes:
\itemize{
\item \code{index}: An index is either attempted to be extracted from the model or
a sequential index is created for plotting purposes
\item \code{observed}: The original time series
\item \code{level}: The level component
\item \code{slope}: The slope component (Not always present)
\item \code{season}: The seasonal component (Not always present)
}
}
\description{
Tidying methods for robets (Robust Error, Trend, Seasonal) exponential smoothing
modeling of time series
}
\examples{
library(dplyr)
library(robets)
library(sweep)

fit_robets <- WWWusage \%>\%
    robets()

sw_tidy(fit_robets)
sw_glance(fit_robets)
sw_augment(fit_robets)
sw_tidy_decomp(fit_robets)

}
\seealso{
\code{\link[robets:robets]{robets::robets()}}
}
