% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/susie_utils.R
\name{kriging_rss}
\alias{kriging_rss}
\title{Compute Distribution of z-scores of Variant j Given Other z-scores, and Detect Possible Allele Switch Issue}
\usage{
kriging_rss(
  z,
  R,
  r_tol = 1e-08,
  s = estimate_s_rss(z, R, r_tol, method = "null-mle")
)
}
\arguments{
\item{z}{A p-vector of z scores.}

\item{R}{A p by p symmetric, positive semidefinite correlation
matrix.}

\item{r_tol}{Tolerance level for eigenvalue check of positive
semidefinite matrix of R.}

\item{s}{an estimated s from \code{estimate_s_rss}}
}
\value{
a list containing a ggplot2 plot object and a table. The plot
  compares observed z score vs the expected value. The possible allele
  switched variants are labeled as red points (log LR > 2 and abs(z) > 2).
  The table summarizes the conditional distribution for each variant
  and the likelihood ratio test.
}
\description{
Under the null, the rss model with regularized LD
  matrix is \eqn{z|R,s ~ N(0, (1-s)R + s I))}. We use a mixture of
  normals to model the conditional distribution of z_j given other z
  scores, \eqn{z_j | z_{-j}, R, s ~ \sum_{k=1}^{K} \pi_k
  N(-\Omega_{j,-j} z_{-j}/\Omega_{jj}, \sigma_{k}^2/\Omega_{jj})},
  \eqn{\Omega = ((1-s)R + sI)^{-1}}, \eqn{\sigma_1, ..., \sigma_k}
  is a grid of fixed positive numbers. We estimate the mixture
  weights \eqn{\pi}  We detect the possible allele switch issue
  using likelihood ratio for each variant.
}
\examples{
set.seed(1)
n = 500
p = 1000
beta = rep(0,p)
beta[1:4] = 0.01
X = matrix(rnorm(n*p),nrow = n,ncol = p)
X = scale(X,center = TRUE,scale = TRUE)
y = drop(X \%*\% beta + rnorm(n))
ss = univariate_regression(X,y)
R = cor(X)
attr(R,"eigen") = eigen(R, symmetric = TRUE)
zhat = with(ss,betahat/sebetahat)
condz = kriging_rss(zhat, R)
condz$plot

}
