% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surv_model_performance_rocs.R
\name{plot.surv_model_performance_rocs}
\alias{plot.surv_model_performance_rocs}
\title{Plot ROC Curves for Survival Models}
\usage{
\method{plot}{surv_model_performance_rocs}(
  x,
  ...,
  title = "ROC curves for selected timepoints",
  subtitle = "default",
  auc = TRUE,
  colors = NULL,
  facet_ncol = NULL
)
}
\arguments{
\item{x}{an object of class \code{"surv_model_performance_rocs"} to be plotted}

\item{...}{additional objects of class \code{"surv_model_performance_rocs"} to be plotted together}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, \code{'default'} automatically generates "created for XXX, YYY models", where XXX and YYY are the explainer labels}

\item{auc}{boolean, whether the AUC values should be plotted}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}

\item{facet_ncol}{number of columns for arranging subplots}
}
\value{
An object of the class \code{ggplot}.
}
\description{
This function plots objects of class \code{"surv_model_performance_rocs"} - ROC curves for
specific time points for survival models created using the \code{model_performance(..., type="roc")}.
}
\examples{
\donttest{
library(survival)
library(survex)

model <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
exp <- explain(model)

m_perf_roc <- model_performance(exp, type = "roc", times = c(100, 300))
plot(m_perf_roc)
}
}
\seealso{
Other functions for plotting 'model_performance_survival' objects: 
\code{\link{plot.model_performance_survival}()},
\code{\link{plot.surv_model_performance}()}
}
\concept{functions for plotting 'model_performance_survival' objects}
