% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_parts.R
\name{predict_parts}
\alias{predict_parts}
\alias{predict_parts.surv_explainer}
\title{Instance Level Parts of Survival Model Predictions}
\usage{
predict_parts(explainer, ...)

\method{predict_parts}{surv_explainer}(
  explainer,
  new_observation,
  ...,
  N = NULL,
  type = "survshap",
  output_type = "survival"
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain()} function}

\item{...}{other parameters which are passed to \code{IBreakDown::break_down} if \code{output_type=="risk"}, or if \code{output_type=="survival"} to \code{surv_shap()} or \code{surv_lime()} functions depending on the selected type}

\item{new_observation}{a new observation for which prediction need to be explained}

\item{N}{the maximum number of observations used for calculation of attributions. If \code{NULL} (default) all observations will be used.}

\item{type}{if \code{output_type == "survival"} must be either \code{"survshap"} or \code{"survlime"}, otherwise refer to the \code{DALEX::predict_parts}}

\item{output_type}{either \code{"survival"} or \code{"risk"} the type of survival model output that should be considered for explanations. If \code{"survival"} the explanations are based on the survival function. Otherwise the scalar risk predictions are used by the \code{DALEX::predict_parts} function.}
}
\value{
An object of class \code{"predict_parts_survival"} and additional classes depending on the type of explanations. It is a list with the element \code{result} containing the results of the calculation.
}
\description{
This function decomposes the model prediction into individual parts, which are attributions of particular variables. The explanations can be made via the SurvLIME and SurvSHAP(t) methods.
}
\section{Additional parameters}{


There are additional parameters that are passed to internal functions
\itemize{
\item for \code{surv_lime}
\itemize{
\item \code{N} -  a positive integer, number of observations generated in the neighbourhood
\item \code{distance_metric} -  character, name of the distance metric to be used, only \code{"euclidean"} is implemented
\item \code{kernel_width} -  a numeric, parameter used for calculating weights, by default it's \code{sqrt(ncol(data)*0.75)}
\item \code{sampling_method} -  character, name of the method of generating neighbourhood, only \code{"gaussian"} is implemented
\item \code{sample_around_instance} -  logical, if the neighbourhood should be generated with the new observation as the center (default), or should the mean of the whole dataset be used as the center
\item \code{max_iter} -  a numeric, maximal number of iteration for the optimization problem
\item \code{categorical_variables} -  character vector, names of variables that should be treated as categories (factors are included by default)
\item \code{k} -  a small positive number > 1, added to chf before taking log, so that weigths aren't negative
}
\item for \code{surv_shap}
\itemize{
\item \code{timestamps} -  a numeric vector, time points at which the survival function will be evaluated
\item \code{y_true} -  a two element numeric vector or matrix of one row and two columns, the first element being the true observed time and the second the status of the observation, used for plotting
\item \code{calculation_method} -  a character, only \code{"kernel"} is implemented for now.
\item \code{aggregation_method} -  a character, either \code{"mean_absolute"} or \code{"integral"}, \code{"max_absolute"}, \code{"sum_of_squares"}
}
}
}

\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
cph_exp <- explain(cph)

cph_predict_parts_survshap <- predict_parts(cph_exp, new_observation = veteran[1, -c(3, 4)])
head(cph_predict_parts_survshap$result)
plot(cph_predict_parts_survshap)

cph_predict_parts_survlime <- predict_parts(cph_exp, new_observation = veteran[1, -c(3, 4)],
                                            type = "survlime")
head(cph_predict_parts_survlime$result)
plot(cph_predict_parts_survlime, type = "local_importance")
}
}
