% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_SRF.R
\name{survsrf_cv}
\alias{survsrf_cv}
\title{Cross-validates SRF model}
\usage{
survsrf_cv(
  df,
  predict.factors,
  fixed_time = NaN,
  outer_cv = 3,
  repeat_cv = 2,
  randomseed = NULL,
  return_models = FALSE,
  inner_cv = 3,
  srf_tuning = list(),
  oob = TRUE
)
}
\arguments{
\item{df}{data frame with the data, "time" and "event" for survival outcome}

\item{predict.factors}{list of predictor names}

\item{fixed_time}{at which performance metrics are computed}

\item{outer_cv}{k in k-fold CV, default 3}

\item{repeat_cv}{if NULL, runs once, otherwise repeats CV}

\item{randomseed}{random seed}

\item{return_models}{TRUE/FALSE, if TRUE returns all CV objects}

\item{inner_cv}{k in the inner loop of k-fold CV for SRF hyperparameters tuning, default is 3}

\item{srf_tuning}{list of tuning parameters for random forest: 1) NULL for using a default tuning grid, or 2) a list("mtry"=c(...), "nodedepth" = c(...), "nodesize" = c(...))}

\item{oob}{TRUE/FALSE use out-of-bag prediction accuracy while tuning instead of cross-validation, TRUE by default}
}
\value{
list of outputs
}
\description{
Cross-validates SRF model
}
\examples{
\donttest{
\dontshow{rfcores_old<- options()$rf.cores; options(rf.cores = 1)}
df <- simulate_nonlinear()
srf_cv <- survsrf_cv(df, names(df)[1:4])
summary(srf_cv)
\dontshow{options(rf.cores=rfcores_old)}
}
}
