% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ic}
\alias{AIC}
\alias{AIC.coxph}
\alias{AICc}
\alias{AICc.coxph}
\alias{BIC}
\alias{BIC.coxph}
\alias{ic}
\title{Information criterion}
\usage{
BIC(object, ...)

\method{BIC}{coxph}(object, ...)

AIC(object, ..., k = 2)

\method{AIC}{coxph}(object, ..., k = 2)

AICc(object, ...)

\method{AICc}{coxph}(object, ..., k = 2)
}
\arguments{
\item{object}{An object of class \code{coxph}}

\item{...}{Not implemented}

\item{k}{The weight of the equivalent degrees of
freedom (edf) of the AIC formula}
}
\value{
A named vector with \describe{
  \item{edf}{the equivalent degrees of freedom for the fitted model fit}
  \item{ IC}{the information criterion, either AIC, AICc or BIC}
}
}
\description{
\bold{I}nformation \bold{C}riterion for a fitted model.
}
\details{
Given a set of candidate models for the same data,
the preferred model is the one with the minimum IC value.
\cr
The Akaike information criterion, AIC, is given by
\deqn{AIC = k.edf -2 \ln L}{
 AIC = k*edf - 2*log L}
Where \eqn{edf} is the
equivalent degrees of freedom
(i.e., equivalent to the number of free parameters in the model) and
\eqn{L} is the model likelihood.
\cr
\eqn{k} is a constant, which is \eqn{=2} for the traditional AIC.
\cr \cr
AIC corrected for finite sample size \eqn{n}, AICc, is
\deqn{AICc = AIC + \frac{k.edf(edf+1)}{n-edf-1}}{
 AICc = AIC + k*edf*(edf+1) / (n-edf-1)}
where \eqn{n} is the sample size. Thus there is a greater penalty
for more parameters.
\cr \cr
The Bayesian information criterion is
\deqn{BIC = \ln n.edf -2 \ln L}{
 BIC = log(n)*edf - 2*log L}
This  penalises models with more parameters to a greater extent.
}
\note{
For survival models the \strong{effective \eqn{n}}
is the number of events rather
than the number of observations. This is used in computing the criteria
above.
}

