% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skew.R
\name{skew}
\alias{skew}
\title{Skewness of a Distribution}
\usage{
skew(x)
}
\arguments{
\item{x}{numeric object containing the values for a variable.}
}
\value{
Skewness value of \code{x}.
}
\description{
Function to obtain the skewness value of a distribution of values.
}
\details{
Skewness value computed on non-missing values using the ratio of \eqn{\Sigma((x - m)^3) / N} to \eqn{\sqrt(\Sigma((x - m)^2) / N) ^3}.
}
\examples{
skew(IceCream$relhumid)
skew(IceCream$temp)
}
\seealso{
\code{\link[sur]{se.skew}}, \code{\link[sur]{skew.ratio}}
}
