## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(superspreading)
library(epiparameter)

## ----prob-epidemic-k----------------------------------------------------------
probability_epidemic(R = 1.5, k = 1, num_init_infect = 1)
probability_epidemic(R = 1.5, k = 0.5, num_init_infect = 1)
probability_epidemic(R = 1.5, k = 0.1, num_init_infect = 1)

## ----prob-epidemic-R----------------------------------------------------------
probability_epidemic(R = 0.5, k = 1, num_init_infect = 1)
probability_epidemic(R = 1.0, k = 1, num_init_infect = 1)
probability_epidemic(R = 1.5, k = 1, num_init_infect = 1)
probability_epidemic(R = 5, k = 1, num_init_infect = 1)

## ----prob-epidemic-a----------------------------------------------------------
probability_epidemic(R = 1.5, k = 1, num_init_infect = 1)
probability_epidemic(R = 1.5, k = 1, num_init_infect = 10)
probability_epidemic(R = 1.5, k = 1, num_init_infect = 100)

## ----epiparam-----------------------------------------------------------------
sars <- epiparameter_db(
  disease = "SARS",
  epi_name = "offspring distribution",
  single_epiparameter = TRUE
)
evd <- epiparameter_db(
  disease = "Ebola Virus Disease",
  epi_name = "offspring distribution",
  single_epiparameter = TRUE
)

## ----params-------------------------------------------------------------------
sars_params <- get_parameters(sars)
sars_params
evd_params <- get_parameters(evd)
evd_params

## ----prob-epidemic-empiric----------------------------------------------------
family(sars)
probability_epidemic(
  R = sars_params[["mean"]],
  k = sars_params[["dispersion"]],
  num_init_infect = 1
)
family(evd)
probability_epidemic(
  R = evd_params[["mean"]],
  k = evd_params[["dispersion"]],
  num_init_infect = 1
)

