% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsStatistical.R
\name{summaryStatistics}
\alias{summaryStatistics}
\alias{hmean}
\alias{gmean}
\alias{MAD}
\alias{fisherskew}
\alias{pearsonskew}
\alias{fisherkurtosis}
\title{Additional summary statistics}
\usage{
hmean(x)

gmean(x)

MAD(x)

fisherskew(x)

pearsonskew(x)

fisherkurtosis(x)
}
\arguments{
\item{x}{a vector of numbers, the sample data (mandatory);}
}
\value{
a summary statistic describing the sample.
}
\description{
superb adds a few summary statistics that can
be used to characterize a dataset. All comes with \code{SE.fct()} and \code{CI.fct()}.
See \insertCite{htc14,htc15}{superb} for more.
\emph{superbPlot-compatible} summary statistics functions must have one parameter:
}
\examples{
# the confidence interval of the mean for default 95\% and 90\% confidence level
gmean( c(1,2,3) )  # the geometric mean; also available in psych::geometric.mean 	
hmean( c(1,2,3) )  # the harmonic mean;  also available in psych::harmonic.mean 	
MAD( c(1,2,3) )    # the median absolute deviation to the median (not the same as mad)
fisherskew( c(1,2,3) )     # the Fisher skew corrected for sample size
fisherkurtosis( c(1,2,3) ) # the Fisher kurtosis corrected for sample size
pearsonskew( c(1,2,3) )    # the Pearson skew

}
\references{
\insertAllCited{}
}
