% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_sg.R
\name{identify_sg}
\alias{identify_sg}
\title{Identify sudden gains.}
\usage{
identify_sg(data, id_var_name, sg_var_list, sg_crit1_cutoff,
  sg_crit2_pct = 0.25, sg_crit3 = TRUE, sg_crit3_alpha = 0.05,
  identify_sg_1to2 = FALSE, crit123_details = FALSE)
}
\arguments{
\item{data}{A data set in wide format including an ID variable and variables for each measurement point.}

\item{id_var_name}{String, specifying the name of the ID variable. Each row should have a unique value.}

\item{sg_var_list}{Vector, specifying the variable names of each measurement point sequentially.}

\item{sg_crit1_cutoff}{Numeric, specifying the cut-off value to be used for the first sudden gains criterion.
If set to \code{NULL} the first criterion wont be applied.}

\item{sg_crit2_pct}{Numeric, specifying the percentage change to be used for the second sudden gains criterion.
If set to \code{NULL} the second criterion wont be applied.}

\item{sg_crit3}{If set to \code{TRUE} the third criterion will be applied automatically adjusting the critical value for missingness.
If set to \code{FALSE} the third criterion wont be applied.}

\item{sg_crit3_alpha}{Numeric, alpha for the two-tailed student t-test to determine the critical value to be used for the third criterion.
Degrees of freedom are based on the number of available data in the three sessions preceding the gain and the three sessions following the gain.}

\item{identify_sg_1to2}{Logical, indicating whether to identify sudden gains from measurement point 1 to 2.
If set to TRUE, this implies that the first variable specified in \code{sg_var_list} represents a baseline measurement point, e.g. pre-intervention assessment.}

\item{crit123_details}{Logical, if set to \code{TRUE} this function returns information about which of the three criteria (e.g. "sg_crit1_2to3", "sg_crit2_2to3", and "sg_crit3_2to3") are met for each session to session interval for all cases.
Variables named "sg_2to3", "sg_3to4" summarise all criteria that were selected to identify sudden gains.}
}
\value{
A wide data set indicating whether sudden gains are present for each session to session interval for all cases in \code{data}.
}
\description{
Function to identify sudden gains in longitudinal data structured in wide format.
}
\examples{
# Identify sudden gains
identify_sg(data = sgdata,
            sg_crit1_cutoff = 7,
            id_var_name = "id",
            sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3",
                            "bdi_s4", "bdi_s5", "bdi_s6",
                            "bdi_s7", "bdi_s8", "bdi_s9",
                            "bdi_s10", "bdi_s11", "bdi_s12"))
}
\references{
Tang, T. Z., & DeRubeis, R. J. (1999). Sudden gains and critical sessions in cognitive-behavioral therapy for depression. Journal of Consulting and Clinical Psychology, 67(6), 894–904. \url{https://doi.org/10.1037/0022-006X.67.6.894}.
}
