% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{style_dir}
\alias{style_dir}
\title{Prettify arbitrary R code}
\usage{
style_dir(path = ".", ..., style = tidyverse_style,
  transformers = style(...), filetype = "R", recursive = TRUE,
  exclude_files = NULL, include_roxygen_examples = TRUE)
}
\arguments{
\item{path}{Path to a directory with files to transform.}

\item{...}{Arguments passed on to the \code{style} function.}

\item{style}{A function that creates a style guide to use, by default
\code{\link[=tidyverse_style]{tidyverse_style()}} (without the parentheses). Not used
further except to construct the argument \code{transformers}. See
\code{\link[=style_guides]{style_guides()}} for details.}

\item{transformers}{A set of transformer functions. This argument is most
conveniently constructed via the \code{style} argument and \code{...}. See
'Examples'.}

\item{filetype}{Vector of file extensions indicating which file types should
be styled. Case is ignored, and the \code{.} is optional, e.g. \code{c(".R", ".Rmd", ".Rnw")} or \code{c("r", "rmd", "rnw")}.}

\item{recursive}{A logical value indicating whether or not files in subdirectories
of \code{path} should be styled as well.}

\item{exclude_files}{Character vector with paths to files that should be
excluded from styling.}

\item{include_roxygen_examples}{Whether or not to style code in roxygen
examples.}
}
\description{
Performs various substitutions in all \code{.R}, \code{.Rmd} and/or \code{.Rnw} files
in a directory (by default only \code{.R} files are styled - see \code{filetype} argument).
Carefully examine the results after running this function!
}
\section{Value}{

Invisibly returns a data frame that indicates for each file considered for
styling whether or not it was actually changed.
}

\section{Warning}{

This function overwrites files (if styling results in a change of the
code to be formatted). It is strongly suggested to only style files
that are under version control or to create a backup copy.

We suggest to first style with \code{scope < "tokens"} and inspect and commit
changes, because these changes are guaranteed to leave the abstract syntax
tree (AST) unchanged. See section 'Round trip validation' for details.

Then, we suggest to style with \code{scope = "tokens"} (if desired) and carefully
inspect the changes to make sure the AST is not changed in an unexpected way
that invalidates code.
}

\section{Round trip validation}{

The following section describes when and how styling is guaranteed to
yield correct code.

If the style guide has \code{scope < "tokens"}, no tokens are changed and the
abstract syntax tree (AST) should not change.
Hence, it is possible to validate the styling by comparing whether the parsed
expression before and after styling have the same AST.
This comparison omits comments. styler compares
error if the AST has changed through styling.

Note that with \code{scope = "tokens"} such a comparison is not conducted because
the AST might well change and such a change is intended. There is no way
styler can validate styling, that is why we inform the user to carefully
inspect the changes.

See section 'Warning' for a good strategy to apply styling safely.
}

\examples{
\dontrun{
style_dir(file_type = "r")
}
}
\seealso{
Other stylers: \code{\link{style_file}},
  \code{\link{style_pkg}}, \code{\link{style_text}},
  \code{\link{styler_addins}}
}
\concept{stylers}
