% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strm-package.R, R/strm.R
\docType{package}
\name{strm}
\alias{strm}
\title{strm: Spatio-temporal regression model}
\usage{
strm(
  formula,
  id,
  data,
  listw,
  time = 2,
  wide = FALSE,
  filter_options = NULL,
  returndf = FALSE,
  ...
)
}
\arguments{
\item{formula}{Model formula specified by user (without lags). Any transformed variables, such as logged-variables, should be specified in the model formula.}

\item{id}{Group identifier (example: state).}

\item{data}{Name of dataframe.}

\item{listw}{Spatial weights list object.}

\item{time}{Number of time periods in the dataset. Lags will be taken for each time period. Default is 2 time periods. For a spatial-only regression model, set \code{time=1}.}

\item{wide}{Boolean indicator. Takes \code{TRUE} if data is in wide format and \code{FALSE} if data is in long format. If data is in wide format, it is assumed that the user is including the temporal lags for the explanatory variables and response variable manually. Default is \code{FALSE}.}

\item{filter_options}{Additional arguments to be passed to \code{dplyr::filter()}. Default is \code{NULL}.}

\item{returndf}{Logical. If modified dataframe should be returned. Default is \code{FALSE}.}

\item{...}{Additional arguments to be passed to \code{spatialreg::errorsarlm()}.}
}
\description{
The \code{strm} function provides maximum likelihood estimation of a spatio-temporal simultaneous autoregressive lag error model. This package is built on the \code{errorsarlm()} function from the \code{spatialreg} package.
}
\details{
Spatio-temporal regression model

Any transformed variables should be included in the formula statement. For example, to request \code{gdp} natural log-transformed, you would build the model formula as \code{log(gdp)}.
}
\examples{
library(spdep)
library(dplyr)
data("Produc", package = "Ecdat")
data("usaww", package = "splm")
usalw <- mat2listw(usaww)
formula <- as.formula( log(gsp)  ~ log(pcap) + log(pc) + log(emp) + unemp)
out1 <- strm(formula, id="state", data=Produc, 
listw = usalw, time=2,wide=FALSE,
filter_options="year==1970 | year==1971")
out2 <- strm(formula, id="state", data=Produc, 
listw= usalw, time=2, wide = FALSE, 
filter_options="year==1970 | year==1971",
 method="Chebyshev")
}
\keyword{internal}
