% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strucParseFormula.R
\name{strucParseFormula}
\alias{strucParseFormula}
\title{Parse Trellis Formula for \code{strucplot}}
\usage{
strucParseFormula(form, data = list())
}
\arguments{
\item{form}{The \code{strucplot} formula to be parsed.}

\item{data}{An optional data frame containing values for any variables in
the formula. Default = list(), which means that all variables will be looked
up in the formula's environment.}
}
\value{
Same as \code{latticeParseFormula} with an additional "form"
 attribute that is the formula used with all conditioning explicitly
 given.
}
\description{
This is a wrapper for \code{latticeParseFormula} that allows the option of using
a "." for the conditioning variables (i.e. after "|") instead of explicitly
writing them out. When so used, it means "all variables in the data argument
\emph{except} those already used to the left of the |". See the Help for
\code{\link{strucplot}} for examples.
}
\details{
Note that this is a convenience option only; the
conditioning can always be explicitly given. Also note that the two options
cannot be combined: either a "." and \emph{only} a "." must be used or
\emph{all} the conditioning variables must be written out.
}
\examples{
 exdat <- data.frame(x = 1:5, alongname = sample( letters[1:3],5, rep=TRUE),
   butalongername = sample(LETTERS[1:2],5, rep = TRUE))
   y <- runif(5)

 strucParseFormula (y ~ x| alongname*butalongername, data = exdat)

 # The same
 strucParseFormula (y ~ x|., data = exdat)

 # The 'data' argument is required with '.'
 \dontrun{
 strucParseFormula (y ~ x|.)
 }

}
\seealso{
\code{\link[lattice]{latticeParseFormula}}
 \code{\link[lattice]{xyplot}}
}

