% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_count_fixed}
\alias{stri_count_fixed}
\title{Count the Number of Fixed Pattern Matches}
\usage{
stri_count_fixed(str, pattern)
}
\arguments{
\item{str}{character vector}

\item{pattern}{character vector}
}
\value{
Returns an integer vector with the number of matches.
}
\description{
This function counts the number of occurrences
of a fixed pattern in a string.
}
\details{
Vectorized over \code{str} and \code{pattern}.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.

For natural language processing this function may be not give
you desired results. Refer to \link{stringi-search-fixed} for more details.
}
\examples{
s <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit."

\dontshow{if (stri_install_check(silent=TRUE))}
stri_count_fixed(s, " ")

\dontshow{if (stri_install_check(silent=TRUE))}
stri_count_fixed(s, "o")

\dontshow{if (stri_install_check(silent=TRUE))}
stri_count_fixed(s, "it")

\dontshow{if (stri_install_check(silent=TRUE))}
stri_count_fixed(s, letters)

\dontshow{if (stri_install_check(silent=TRUE))}
stri_count_fixed("babab", "b")

\dontshow{if (stri_install_check(silent=TRUE))}
stri_count_fixed(c("stringi", "123"), "string")
}
\seealso{
Other search_count: \code{\link{stri_count_charclass}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_count_regex}}; \code{\link{stri_count}};
  \code{\link{stringi-search}}

Other search_fixed: \code{\link{stri_detect_fixed}};
  \code{\link{stri_locate_all_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_first_fixed}},
  \code{\link{stri_locate_last_fixed}},
  \code{\link{stri_locate_last_fixed}};
  \code{\link{stri_replace_all_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_first_fixed}},
  \code{\link{stri_replace_last_fixed}},
  \code{\link{stri_replace_last_fixed}};
  \code{\link{stri_split_fixed}};
  \code{\link{stringi-search-fixed}};
  \code{\link{stringi-search}}
}

