% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-by-nums.R
\name{str_split_by_nums}
\alias{str_split_by_nums}
\title{Split a string by its numeric characters.}
\usage{
str_split_by_nums(string, decimals = FALSE, leading_decimals = FALSE,
  negs = FALSE)
}
\arguments{
\item{string}{A string.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}
}
\description{
Break a string wherever you go from a numeric character to a non-numeric or
vice-versa.
}
\examples{
str_split_by_nums(c("abc123def456.789gh", "a1b2c344"))
str_split_by_nums("abc123def456.789gh", decimals = TRUE)
str_split_by_nums("22")
}
