% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_tox.R
\name{multi_tox}
\alias{multi_tox}
\title{Predict the survival of binary toxicant mixtures}
\usage{
multi_tox(
  model_a,
  model_b,
  concentration_a,
  concentration_b,
  sa_contribution = 0.5,
  survival_max = 100
)
}
\arguments{
\item{model_a, model_b}{The ecxsys models of the toxicants.}

\item{concentration_a, concentration_b}{The concentrations of the toxicants in
the mixture. Both vectors must either be the same length or the longer
length must be a multiple of the shorter length. That's because the shorter
concentration vector gets recycled to the length of the longer one.}

\item{sa_contribution}{The proportion of stress addition contributing to the
calculation of the toxicant stress in the mixture. Must be between 0 and 1
where 1 stands for 100 \% stress addition.}

\item{survival_max}{Controls the scaling of the result. This represents the
maximum value the survival could possibly reach. For survival data in
percent this should be 100 (the default).}
}
\value{
A data frame with columns of the supplied concentrations and the
  corresponding mixture survival and stresses.
}
\description{
The Multi-TOX model predicts the effects of binary toxicant mixtures based on
three-phasic concentration-response relationships. See the publication for
details.
}
\details{
The predictions are symmetric, i.e. it does not matter which of the toxicant
models is a or b as long as the concentration arguments are supplied in the
same order.

This method is only suitable for experiments without or with low
environmental stress. Any environmental stress supplied as arguments to
\code{\link{ecxsys}} in \code{model_a} or \code{model_b} is ignored.
}
\examples{
# Using a data set which is included in this package. See ?multiple_stress
ms <- multiple_stress
esfen <- ms[ms$food == 1 & ms$prochloraz == 0, ]
proch <- ms[ms$food == 1 & ms$esfenvalerate == 0, ]

model_esfen <- ecxsys(
    concentration = esfen$esfenvalerate,
    survival_tox_observed = esfen$survival,
    hormesis_concentration = 0.1
)
model_proch <- ecxsys(
    concentration = proch$prochloraz,
    survival_tox_observed = proch$survival,
    hormesis_concentration = 100
)

# Predict the survival at 8 different esfenvalerate concentrations
# but keep the prochloraz concentration constant at 32:
mt <- multi_tox(
    model_esfen,
    model_proch,
    c(0, 0.0001, 0.001, 0.01, 0.1, 0.316, 1, 3.16),
    32,
    sa_contribution = 0.8
)
mt[1:3]  # The concentrations and survival of the 8 mixtures.

# Predict the survival at 4 different combinations
# of esfenvalerate and prochloraz:
mt <- multi_tox(
    model_esfen,
    model_proch,
    c(0.1, 0.2, 0.3, 0.4),
    c(0, 1, 32, 100),
    sa_contribution = 0.8
)
mt[1:3]  # The concentrations and survival of the 4 mixtures.


}
\references{
Liess, M., Henz, S., Shahid, N., 2020. Modelling the synergistic
  effects of toxicant mixtures. Manuscript submitted for publication.
}
