/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import moa.AbstractMOAObject;
import moa.core.Example;
import moa.core.Measurement;
import moa.evaluation.MultiTargetPerformanceEvaluator;

public class BasicMultiLabelPerformanceEvaluator
extends AbstractMOAObject
implements MultiTargetPerformanceEvaluator {
    protected int L;
    double sumAccuracy = 0.0;
    double sumHamming = 0.0;
    double sumAccuracy2 = 0.0;
    double sumPrecision = 0.0;
    double sumRecall = 0.0;
    double sumFmeasure = 0.0;
    int sumExamples = 0;

    @Override
    public void reset() {
        this.sumAccuracy = 0.0;
        this.sumHamming = 0.0;
        this.sumExamples = 0;
        this.sumAccuracy2 = 0.0;
        this.sumPrecision = 0.0;
        this.sumRecall = 0.0;
        this.sumFmeasure = 0.0;
    }

    @Override
    public void addResult(Example<Instance> example, Prediction y) {
        int sumReunion = 0;
        int sumInterse = 0;
        int sumOnesTrue = 0;
        int sumOnesPred = 0;
        MultiLabelInstance x = (MultiLabelInstance)example.getData();
        if (this.L == 0) {
            this.L = x.numberOutputTargets();
        }
        if (y == null) {
            System.err.print("[WARNING] Prediction is null! (Ignoring this prediction)");
        } else if (y.numOutputAttributes() < x.numOutputAttributes()) {
            System.err.println("[WARNING] Only " + y.numOutputAttributes() + " labels found! (Expecting " + x.numOutputAttributes() + ")\n (Ignoring this prediction)");
        } else {
            ++this.sumExamples;
            int correct = 0;
            for (int j = 0; j < y.numOutputAttributes(); ++j) {
                int yp = y.getVote(j, 1) > y.getVote(j, 0) ? 1 : 0;
                int y_true = (int)x.valueOutputAttribute(j);
                if (y_true == yp) {
                    ++correct;
                }
                if (y_true == 1 || yp == 1) {
                    ++sumReunion;
                }
                if (y_true == 1 && yp == 1) {
                    ++sumInterse;
                }
                if (y_true == 1) {
                    ++sumOnesTrue;
                }
                if (yp != 1) continue;
                ++sumOnesPred;
            }
            this.sumAccuracy2 = sumReunion > 0 ? (this.sumAccuracy2 += (double)sumInterse / (double)sumReunion) : (this.sumAccuracy2 += 0.0);
            if (sumOnesTrue > 0) {
                this.sumPrecision += (double)sumInterse / (double)sumOnesTrue;
            }
            if (sumOnesPred > 0) {
                this.sumRecall += (double)(sumInterse / sumOnesPred);
            }
            this.sumFmeasure = sumOnesPred + sumOnesTrue > 0 ? (this.sumFmeasure += 2.0 * (double)sumInterse / (double)(sumOnesPred + sumOnesTrue)) : (this.sumFmeasure += 0.0);
            this.sumHamming += (double)correct / (double)this.L;
            this.sumAccuracy += correct == this.L ? 1.0 : 0.0;
        }
    }

    @Override
    public Measurement[] getPerformanceMeasurements() {
        Measurement[] m = new Measurement[]{new Measurement("Exact Match", this.sumAccuracy / (double)this.sumExamples), new Measurement("Accuracy", this.sumAccuracy2 / (double)this.sumExamples), new Measurement("Hamming Score", this.sumHamming / (double)this.sumExamples), new Measurement("Precision", this.sumPrecision / (double)this.sumExamples), new Measurement("Recall", this.sumRecall / (double)this.sumExamples), new Measurement("F-Measure", this.sumFmeasure / (double)this.sumExamples)};
        return m;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append("Basic Multi-label Performance Evaluator");
    }

    @Override
    public void addResult(Example<Instance> example, double[] classVotes) {
    }
}

