/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.IntOption;
import moa.core.Measurement;
import moa.core.ObjectRepository;
import moa.evaluation.LearningEvaluation;
import moa.evaluation.preview.LearningCurve;
import moa.options.ClassOption;
import moa.recommender.dataset.Dataset;
import moa.recommender.predictor.RatingPredictor;
import moa.recommender.rc.data.RecommenderData;
import moa.tasks.AuxiliarMainTask;
import moa.tasks.TaskMonitor;

public class EvaluateOnlineRecommender
extends AuxiliarMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption datasetOption = new ClassOption("dataset", 'd', "Dataset to evaluate.", Dataset.class, "moa.recommender.dataset.impl.MovielensDataset");
    public ClassOption ratingPredictorOption = new ClassOption("ratingPredictor", 's', "Rating Predictor to evaluate on.", RatingPredictor.class, "moa.recommender.predictor.BRISMFPredictor");
    public IntOption sampleFrequencyOption = new IntOption("sampleFrequency", 'f', "How many instances between samples of the learning performance.", 100, 0, Integer.MAX_VALUE);

    @Override
    public String getPurposeString() {
        return "Evaluates a online reccommender system.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    public Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Dataset d = (Dataset)this.getPreparedClassOption(this.datasetOption);
        RatingPredictor rp = (RatingPredictor)this.getPreparedClassOption(this.ratingPredictorOption);
        LearningCurve learningCurve = new LearningCurve("n");
        RecommenderData data = rp.getData();
        data.clear();
        data.disableUpdates(false);
        long start = System.currentTimeMillis();
        long evalTime = 0L;
        double sum = 0.0;
        int n = 0;
        int sampleFrequency = this.sampleFrequencyOption.getValue();
        int count = 0;
        while (d.next()) {
            ++count;
        }
        d.reset();
        while (d.next()) {
            Integer user = d.curUserID();
            Integer item = d.curItemID();
            Double rating = d.curRating();
            long startPredTime = System.currentTimeMillis();
            double pred = rp.predictRating(user, item);
            sum += Math.pow(pred - rating, 2.0);
            evalTime += System.currentTimeMillis() - startPredTime;
            data.setRating(user, item, rating);
            if (++n % sampleFrequency != sampleFrequency - 1) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            monitor.setCurrentActivityFractionComplete((double)n / (double)count);
            learningCurve.insertEntry(new LearningEvaluation(new Measurement[]{new Measurement("n", n), new Measurement("RMSE", Math.sqrt(sum / (double)n)), new Measurement("trainingTime", (int)((System.currentTimeMillis() - start - evalTime) / 1000L)), new Measurement("evalTime", (int)(evalTime / 1000L))}));
            if (!monitor.resultPreviewRequested()) continue;
            monitor.setLatestResultPreview(learningCurve.headerToString() + "\n" + learningCurve.entryToString(learningCurve.numEntries() - 1));
        }
        return learningCurve;
    }
}

