/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import com.yahoo.labs.samoa.instances.Instance;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import moa.classifiers.bayes.NaiveBayes;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.driftdetection.ADWIN;
import moa.classifiers.trees.HoeffdingTree;
import moa.core.DoubleVector;
import moa.core.MiscUtils;
import moa.core.Utils;

public class HoeffdingAdaptiveTree
extends HoeffdingTree {
    private static final long serialVersionUID = 1L;
    protected int alternateTrees;
    protected int prunedAlternateTrees;
    protected int switchedAlternateTrees;

    @Override
    public String getPurposeString() {
        return "Hoeffding Adaptive Tree for evolving data streams that uses ADWIN to replace branches for new ones.";
    }

    @Override
    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new AdaLearningNode(initialClassObservations);
    }

    @Override
    protected HoeffdingTree.SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
        return new AdaSplitNode(splitTest, classObservations, size);
    }

    @Override
    protected HoeffdingTree.SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
        return new AdaSplitNode(splitTest, classObservations);
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLearningNode();
            this.activeLeafNodeCount = 1;
        }
        ((NewNode)((Object)this.treeRoot)).learnFromInstance(inst, this, null, -1);
    }

    public HoeffdingTree.FoundNode[] filterInstanceToLeaves(Instance inst, HoeffdingTree.SplitNode parent, int parentBranch, boolean updateSplitterCounts) {
        LinkedList<HoeffdingTree.FoundNode> nodes = new LinkedList<HoeffdingTree.FoundNode>();
        ((NewNode)((Object)this.treeRoot)).filterInstanceToLeaves(inst, parent, parentBranch, nodes, updateSplitterCounts);
        return nodes.toArray(new HoeffdingTree.FoundNode[nodes.size()]);
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot != null) {
            HoeffdingTree.FoundNode[] foundNodes = this.filterInstanceToLeaves(inst, null, -1, false);
            DoubleVector result = new DoubleVector();
            boolean predictionPaths = false;
            for (HoeffdingTree.FoundNode foundNode : foundNodes) {
                if (foundNode.parentBranch == -999) continue;
                HoeffdingTree.Node leafNode = foundNode.node;
                if (leafNode == null) {
                    leafNode = foundNode.parent;
                }
                double[] dist = leafNode.getClassVotes(inst, this);
                result.addValues(dist);
            }
            return result.getArrayRef();
        }
        return new double[0];
    }

    public static class AdaLearningNode
    extends HoeffdingTree.LearningNodeNBAdaptive
    implements NewNode {
        private static final long serialVersionUID = 1L;
        protected ADWIN estimationErrorWeight;
        public boolean ErrorChange = false;
        protected int randomSeed = 1;
        protected Random classifierRandom = new Random(this.randomSeed);

        @Override
        public int calcByteSize() {
            int byteSize = super.calcByteSize();
            if (this.estimationErrorWeight != null) {
                byteSize += this.estimationErrorWeight.measureByteSize();
            }
            return byteSize;
        }

        public AdaLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public int numberLeaves() {
            return 1;
        }

        @Override
        public double getErrorEstimation() {
            if (this.estimationErrorWeight != null) {
                return this.estimationErrorWeight.getEstimation();
            }
            return 0.0;
        }

        @Override
        public double getErrorWidth() {
            return this.estimationErrorWeight.getWidth();
        }

        @Override
        public boolean isNullError() {
            return this.estimationErrorWeight == null;
        }

        @Override
        public void killTreeChilds(HoeffdingAdaptiveTree ht) {
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingAdaptiveTree ht, HoeffdingTree.SplitNode parent, int parentBranch) {
            int ClassPrediction;
            boolean blCorrect;
            int trueClass = (int)inst.classValue();
            int k = MiscUtils.poisson(1.0, this.classifierRandom);
            Instance weightedInst = inst.copy();
            if (k > 0) {
                weightedInst.setWeight(inst.weight() * (double)k);
            }
            boolean bl = blCorrect = trueClass == (ClassPrediction = Utils.maxIndex(this.getClassVotes(inst, ht)));
            if (this.estimationErrorWeight == null) {
                this.estimationErrorWeight = new ADWIN();
            }
            double oldError = this.getErrorEstimation();
            this.ErrorChange = this.estimationErrorWeight.setInput(blCorrect ? 0.0 : 1.0);
            if (this.ErrorChange && oldError > this.getErrorEstimation()) {
                this.ErrorChange = false;
            }
            this.learnFromInstance(weightedInst, ht);
            double weightSeen = this.getWeightSeen();
            if (weightSeen - this.getWeightSeenAtLastSplitEvaluation() >= (double)ht.gracePeriodOption.getValue()) {
                ht.attemptToSplit(this, parent, parentBranch);
                this.setWeightSeenAtLastSplitEvaluation(weightSeen);
            }
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            int predictionOption = ((HoeffdingAdaptiveTree)ht).leafpredictionOption.getChosenIndex();
            double[] dist = predictionOption == 0 ? this.observedClassDistribution.getArrayCopy() : (predictionOption == 1 ? NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers) : (this.mcCorrectWeight > this.nbCorrectWeight ? this.observedClassDistribution.getArrayCopy() : NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)));
            double distSum = Utils.sum(dist);
            if (distSum * this.getErrorEstimation() * this.getErrorEstimation() > 0.0) {
                Utils.normalize(dist, distSum * this.getErrorEstimation() * this.getErrorEstimation());
            }
            return dist;
        }

        @Override
        public void filterInstanceToLeaves(Instance inst, HoeffdingTree.SplitNode splitparent, int parentBranch, List<HoeffdingTree.FoundNode> foundNodes, boolean updateSplitterCounts) {
            foundNodes.add(new HoeffdingTree.FoundNode(this, splitparent, parentBranch));
        }
    }

    public static class AdaSplitNode
    extends HoeffdingTree.SplitNode
    implements NewNode {
        private static final long serialVersionUID = 1L;
        protected HoeffdingTree.Node alternateTree;
        protected ADWIN estimationErrorWeight;
        public boolean ErrorChange = false;
        protected int randomSeed = 1;
        protected Random classifierRandom = new Random(this.randomSeed);

        @Override
        public int calcByteSizeIncludingSubtree() {
            int byteSize = this.calcByteSize();
            if (this.alternateTree != null) {
                byteSize += this.alternateTree.calcByteSizeIncludingSubtree();
            }
            if (this.estimationErrorWeight != null) {
                byteSize += this.estimationErrorWeight.measureByteSize();
            }
            for (HoeffdingTree.Node child : this.children) {
                if (child == null) continue;
                byteSize += child.calcByteSizeIncludingSubtree();
            }
            return byteSize;
        }

        public AdaSplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
            super(splitTest, classObservations, size);
        }

        public AdaSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
            super(splitTest, classObservations);
        }

        @Override
        public int numberLeaves() {
            int numLeaves = 0;
            for (HoeffdingTree.Node child : this.children) {
                if (child == null) continue;
                numLeaves += ((NewNode)((Object)child)).numberLeaves();
            }
            return numLeaves;
        }

        @Override
        public double getErrorEstimation() {
            return this.estimationErrorWeight.getEstimation();
        }

        @Override
        public double getErrorWidth() {
            double w = 0.0;
            if (!this.isNullError()) {
                w = this.estimationErrorWeight.getWidth();
            }
            return w;
        }

        @Override
        public boolean isNullError() {
            return this.estimationErrorWeight == null;
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingAdaptiveTree ht, HoeffdingTree.SplitNode parent, int parentBranch) {
            int childBranch;
            HoeffdingTree.Node child;
            boolean blCorrect;
            int trueClass = (int)inst.classValue();
            int k = MiscUtils.poisson(1.0, this.classifierRandom);
            Instance weightedInst = inst.copy();
            if (k > 0) {
                // empty if block
            }
            int ClassPrediction = 0;
            if (this.filterInstanceToLeaf((Instance)inst, (HoeffdingTree.SplitNode)parent, (int)parentBranch).node != null) {
                ClassPrediction = Utils.maxIndex(this.filterInstanceToLeaf((Instance)inst, (HoeffdingTree.SplitNode)parent, (int)parentBranch).node.getClassVotes(inst, ht));
            }
            boolean bl = blCorrect = trueClass == ClassPrediction;
            if (this.estimationErrorWeight == null) {
                this.estimationErrorWeight = new ADWIN();
            }
            double oldError = this.getErrorEstimation();
            this.ErrorChange = this.estimationErrorWeight.setInput(blCorrect ? 0.0 : 1.0);
            if (this.ErrorChange && oldError > this.getErrorEstimation()) {
                this.ErrorChange = false;
            }
            if (this.ErrorChange) {
                this.alternateTree = ht.newLearningNode();
                ++ht.alternateTrees;
            } else if (this.alternateTree != null && !((NewNode)((Object)this.alternateTree)).isNullError() && this.getErrorWidth() > 300.0 && ((NewNode)((Object)this.alternateTree)).getErrorWidth() > 300.0) {
                double oldErrorRate = this.getErrorEstimation();
                double altErrorRate = ((NewNode)((Object)this.alternateTree)).getErrorEstimation();
                double fDelta = 0.05;
                double fN = 1.0 / ((NewNode)((Object)this.alternateTree)).getErrorWidth() + 1.0 / this.getErrorWidth();
                double Bound = Math.sqrt(2.0 * oldErrorRate * (1.0 - oldErrorRate) * Math.log(2.0 / fDelta) * fN);
                if (Bound < oldErrorRate - altErrorRate) {
                    ht.activeLeafNodeCount -= this.numberLeaves();
                    ht.activeLeafNodeCount += ((NewNode)((Object)this.alternateTree)).numberLeaves();
                    this.killTreeChilds(ht);
                    if (parent != null) {
                        parent.setChild(parentBranch, this.alternateTree);
                    } else {
                        ht.treeRoot = ((AdaSplitNode)ht.treeRoot).alternateTree;
                    }
                    ++ht.switchedAlternateTrees;
                } else if (Bound < altErrorRate - oldErrorRate) {
                    if (this.alternateTree instanceof HoeffdingTree.ActiveLearningNode) {
                        this.alternateTree = null;
                    } else if (this.alternateTree instanceof HoeffdingTree.InactiveLearningNode) {
                        this.alternateTree = null;
                    } else {
                        ((AdaSplitNode)this.alternateTree).killTreeChilds(ht);
                    }
                    ++ht.prunedAlternateTrees;
                }
            }
            if (this.alternateTree != null) {
                ((NewNode)((Object)this.alternateTree)).learnFromInstance(weightedInst, ht, parent, parentBranch);
            }
            if ((child = this.getChild(childBranch = this.instanceChildIndex(inst))) != null) {
                ((NewNode)((Object)child)).learnFromInstance(weightedInst, ht, this, childBranch);
            }
        }

        @Override
        public void killTreeChilds(HoeffdingAdaptiveTree ht) {
            for (HoeffdingTree.Node child : this.children) {
                if (child == null) continue;
                if (child instanceof AdaSplitNode && ((AdaSplitNode)child).alternateTree != null) {
                    ((NewNode)((Object)((AdaSplitNode)child).alternateTree)).killTreeChilds(ht);
                    ++ht.prunedAlternateTrees;
                }
                if (child instanceof AdaSplitNode) {
                    ((NewNode)((Object)child)).killTreeChilds(ht);
                }
                if (child instanceof HoeffdingTree.ActiveLearningNode) {
                    child = null;
                    --ht.activeLeafNodeCount;
                    continue;
                }
                if (!(child instanceof HoeffdingTree.InactiveLearningNode)) continue;
                child = null;
                --ht.inactiveLeafNodeCount;
            }
        }

        @Override
        public void filterInstanceToLeaves(Instance inst, HoeffdingTree.SplitNode myparent, int parentBranch, List<HoeffdingTree.FoundNode> foundNodes, boolean updateSplitterCounts) {
            int childIndex;
            if (updateSplitterCounts) {
                this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            }
            if ((childIndex = this.instanceChildIndex(inst)) >= 0) {
                HoeffdingTree.Node child = this.getChild(childIndex);
                if (child != null) {
                    ((NewNode)((Object)child)).filterInstanceToLeaves(inst, this, childIndex, foundNodes, updateSplitterCounts);
                } else {
                    foundNodes.add(new HoeffdingTree.FoundNode(null, this, childIndex));
                }
            }
            if (this.alternateTree != null) {
                ((NewNode)((Object)this.alternateTree)).filterInstanceToLeaves(inst, this, -999, foundNodes, updateSplitterCounts);
            }
        }
    }

    public static interface NewNode {
        public int numberLeaves();

        public double getErrorEstimation();

        public double getErrorWidth();

        public boolean isNullError();

        public void killTreeChilds(HoeffdingAdaptiveTree var1);

        public void learnFromInstance(Instance var1, HoeffdingAdaptiveTree var2, HoeffdingTree.SplitNode var3, int var4);

        public void filterInstanceToLeaves(Instance var1, HoeffdingTree.SplitNode var2, int var3, List<HoeffdingTree.FoundNode> var4, boolean var5);
    }
}

