% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.gtypes.R
\name{as.data.frame.gtypes}
\alias{as.data.frame.gtypes}
\alias{as.data.frame,gtypes-method}
\alias{as.data.frame}
\alias{as.matrix,gtypes-method}
\alias{as.matrix.gtypes}
\alias{as.matrix}
\title{Convert \code{gtypes} to data.frame or matrix}
\usage{
\S4method{as.data.frame}{gtypes}(
  x,
  one.col = FALSE,
  sep = "/",
  ids = TRUE,
  strata = TRUE,
  sort.alleles = TRUE,
  coded.snps = FALSE,
  ref.allele = NULL,
  ...
)

\S4method{as.matrix}{gtypes}(
  x,
  one.col = FALSE,
  sep = "/",
  ids = TRUE,
  strata = TRUE,
  sort.alleles = TRUE,
  ...
)
}
\arguments{
\item{x}{a \linkS4class{gtypes} object.}

\item{one.col}{logical. If \code{TRUE}, then result has one column per 
locus.}

\item{sep}{character to use to separate alleles if \code{one.col} is 
\code{TRUE}.}

\item{ids}{logical. include a column for individual identifiers (\code{ids})?}

\item{strata}{logical. include a column for current statification 
(\code{strata})?}

\item{sort.alleles}{logical. for non-haploid objects, should alleles be
sorted in genotypes or left in original order? (only takes affect if
\code{one.col = TRUE})}

\item{coded.snps}{return diploid SNPs coded as 0 (reference allele homozygote), 
1 (heterozygote), or 2 (alternate allele homozygote). If this is `TRUE`,  
the data is diploid, and all loci are biallelic, a data frame of 
coded genotypes will be returned with one column per locus.}

\item{ref.allele}{an optional vector of reference alleles for each SNP. 
Only used if `coded.snps = TRUE`. If provided, it must be at least as long 
as there are biallelic SNPs in \code{g}. If named, the names must 
match those of all loci in \code{g}. If set to `NULL` (default) the 
major allele at each SNP is used as the reference.}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
A \code{data.frame} or \code{matrix} with one row per individual.
}
\description{
Create a formatted data.frame or matrix 
  from a \linkS4class{gtypes} object.
}
\examples{
data(msats.g)

# with defaults (alleles in multiple columns, with ids and stratification)
df <- as.data.frame(msats.g)
str(df)

# one column per locus
onecol.df <- as.data.frame(msats.g, one.col = TRUE)
str(onecol.df)

# just the genotypes
genotypes.df <- as.data.frame(msats.g, one.col = TRUE, ids = FALSE, strata = FALSE)
str(genotypes.df)

# as a matrix instead
genotypes.mat <- as.matrix(msats.g)
str(genotypes.mat)

}
\seealso{
\link{df2gtypes} \link[strataG]{as.matrix}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
