% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.array.gtypes.R
\docType{methods}
\name{as.array.gtypes}
\alias{as.array.gtypes}
\alias{as.array,gtypes-method}
\alias{as.array}
\title{Convert \code{gtypes} To \code{array}}
\usage{
\S4method{as.array}{gtypes}(x, ids = NULL, loci = NULL, drop = TRUE, ...)
}
\arguments{
\item{x}{a \linkS4class{gtypes} object.}

\item{ids}{vector of individual ids.}

\item{loci}{vector of loci.}

\item{drop}{if \code{TRUE} the array is coerced to the lowest possible dimension.}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
A three dimensional \code{array} with with dimeinsions of:
}
\description{
Create a 3-dimensional array from a \linkS4class{gtypes} object.
}
\examples{
data(msats.g)
msats.arr <- as.array(msats.g)

msats.arr

}
\seealso{
\link[strataG]{as.data.frame} \link[strataG]{as.matrix}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
