% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastsimcoal.R
\name{fastsimcoal}
\alias{fastsimcoal}
\title{Run fastsimcoal}
\usage{
fastsimcoal(pop.info, locus.params, mig.rates = NULL, hist.ev = NULL,
  label = NULL, quiet = TRUE, delete.files = TRUE, exec = "fsc252",
  num.cores = NULL)
}
\arguments{
\item{pop.info}{matrix of population sampling information created by the 
\code{\link{fscPopInfo}} function.}

\item{locus.params}{data.frame specifying loci to simulate created by the 
\code{\link{fscLocusParams}} function.}

\item{mig.rates}{a matrix or list of matrices giving the migration rates 
between pairs of populations.}

\item{hist.ev}{matrix of historical events created by the 
\code{\link{fscHistEv}} function.}

\item{label}{character string to label files with.}

\item{quiet}{logical. Run quietly?}

\item{delete.files}{logical. Delete files when done?}

\item{exec}{name of fastsimcoal executable.}

\item{num.cores}{number of cores to use.}
}
\description{
Run a fastsimcoal simulation and load results into a 
  \linkS4class{gtypes} object.
}
\note{
fastsimcoal is not included with \code{strataG} and must be downloaded 
  separately. Additionally, it must be installed such that it can be run from 
  the command line in the current working directory. See the vignette 
  for \code{external.programs} for installation instructions.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Excoffier, L. and Foll, M (2011) fastsimcoal: a continuous-time 
  coalescent simulator of genomic diversity under arbitrarily complex 
  evolutionary scenarios Bioinformatics 27: 1332-1334.\cr
  \url{http://cmpg.unibe.ch/software/fastsimcoal2/}
}

